/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.sql.Driver;
import javax.sql.DataSource;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.conn.DriverDataSource;
import org.apache.cayenne.conn.PoolDataSource;
import org.apache.cayenne.conn.PoolManager;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;

public class PropertyDataSourceFactory
implements DataSourceFactory {
    @Inject
    protected RuntimeProperties properties;
    @Inject
    protected JdbcEventLogger jdbcEventLogger;
    @Inject
    private AdhocObjectFactory objectFactory;

    @Override
    public DataSource getDataSource(DataNodeDescriptor nodeDescriptor) throws Exception {
        String suffix = "." + nodeDescriptor.getDataChannelDescriptor().getName() + "." + nodeDescriptor.getName();
        String driverClass = this.getProperty("cayenne.jdbc.driver", suffix);
        String url = this.getProperty("cayenne.jdbc.url", suffix);
        String username = this.getProperty("cayenne.jdbc.username", suffix);
        String password = this.getProperty("cayenne.jdbc.password", suffix);
        int minConnections = this.getIntProperty("cayenne.jdbc.min_connections", suffix, 1);
        int maxConnections = this.getIntProperty("cayenne.jdbc.max_connections", suffix, 1);
        Driver driver = (Driver)this.objectFactory.newInstance(Driver.class, driverClass);
        DriverDataSource driverDS = new DriverDataSource(driver, url, username, password);
        driverDS.setLogger(this.jdbcEventLogger);
        PoolDataSource poolDS = new PoolDataSource(driverDS);
        try {
            return new PoolManager(poolDS, minConnections, maxConnections, username, password, this.properties.getLong("cayenne.jdbc.max_wait", 20000L));
        }
        catch (Exception e) {
            this.jdbcEventLogger.logConnectFailure(e);
            throw e;
        }
    }

    protected int getIntProperty(String propertyName, String suffix, int defaultValue) {
        String string = this.getProperty(propertyName, suffix);
        if (string == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Invalid int property '%s': '%s'", propertyName, string);
        }
    }

    protected String getProperty(String propertyName, String suffix) {
        String value = this.properties.get(propertyName + suffix);
        return value != null ? value : this.properties.get(propertyName);
    }
}

