/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.util.ArrayList;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class PkGeneratorIT
extends ServerCase {
    @Inject
    private UnitDbAdapter accessStackAdapter;
    @Inject
    private DataNode node;
    private PkGenerator pkGenerator;
    private DbEntity paintingEntity;

    @Before
    public void setUp() throws Exception {
        this.pkGenerator = this.node.getAdapter().getPkGenerator();
        this.paintingEntity = this.node.getEntityResolver().getDbEntity("PAINTING");
        ArrayList<DbEntity> list = new ArrayList<DbEntity>();
        list.add(this.paintingEntity);
        this.pkGenerator.createAutoPk(this.node, list);
        this.pkGenerator.reset();
    }

    @Test
    public void testGeneratePkForDbEntity() throws Exception {
        int testSize;
        ArrayList<Object> pkList = new ArrayList<Object>();
        int n = testSize = this.pkGenerator instanceof JdbcPkGenerator ? ((JdbcPkGenerator)this.pkGenerator).getPkCacheSize() * 2 : 25;
        if (testSize < 25) {
            testSize = 25;
        }
        for (int i = 0; i < testSize; ++i) {
            Object pk = this.pkGenerator.generatePk(this.node, this.paintingEntity.getPrimaryKeys().iterator().next());
            Assert.assertNotNull((Object)pk);
            Assert.assertTrue((boolean)(pk instanceof Number));
            if (this.accessStackAdapter.supportsBatchPK() && pkList.size() > 0) {
                Number last = (Number)pkList.get(pkList.size() - 1);
                Assert.assertEquals((long)(last.intValue() + 1), (long)((Number)pk).intValue());
            }
            pkList.add(pk);
        }
    }
}

