/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.db2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;

public class DB2PkGenerator
extends JdbcPkGenerator {
    private static final String _SEQUENCE_PREFIX = "S_";

    DB2PkGenerator(JdbcAdapter adapter) {
        super(adapter);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected long longPkFromDatabase(DataNode node, DbEntity entity) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void createAutoPk(DataNode node, List<DbEntity> dbEntities) throws Exception {
        List<String> sequences = this.getExistingSequences(node);
        for (DbEntity entity : dbEntities) {
            if (sequences.contains(this.sequenceName(entity))) continue;
            this.runUpdate(node, this.createSequenceString(entity));
        }
    }

    @Override
    public List<String> createAutoPkStatements(List<DbEntity> dbEntities) {
        ArrayList<String> list = new ArrayList<String>(dbEntities.size());
        for (DbEntity entity : dbEntities) {
            list.add(this.createSequenceString(entity));
        }
        return list;
    }

    @Override
    public void dropAutoPk(DataNode node, List<DbEntity> dbEntities) throws Exception {
        List<String> sequences = this.getExistingSequences(node);
        for (DbEntity ent : dbEntities) {
            String name;
            if (ent.getDataMap().isQuotingSQLIdentifiers()) {
                DbEntity tempEnt = new DbEntity();
                DataMap dm = new DataMap();
                dm.setQuotingSQLIdentifiers(false);
                tempEnt.setDataMap(dm);
                tempEnt.setName(ent.getName());
                name = this.sequenceName(tempEnt);
            } else {
                name = this.sequenceName(ent);
            }
            if (!sequences.contains(name)) continue;
            this.runUpdate(node, this.dropSequenceString(ent));
        }
    }

    @Override
    public List<String> dropAutoPkStatements(List<DbEntity> dbEntities) {
        ArrayList<String> list = new ArrayList<String>(dbEntities.size());
        for (DbEntity entity : dbEntities) {
            list.add(this.dropSequenceString(entity));
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    protected List<String> getExistingSequences(DataNode node) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String sequenceName(DbEntity entity) {
        String entName = entity.getName();
        String seqName = _SEQUENCE_PREFIX + entName;
        return this.adapter.getQuotingStrategy().quotedIdentifier(entity, entity.getCatalog(), entity.getSchema(), seqName);
    }

    protected String dropSequenceString(DbEntity entity) {
        return "DROP SEQUENCE " + this.sequenceName(entity) + " RESTRICT ";
    }

    protected String createSequenceString(DbEntity entity) {
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE SEQUENCE ").append(this.sequenceName(entity)).append(" START WITH ").append(this.pkStartValue).append(" INCREMENT BY ").append(this.getPkCacheSize()).append(" NO MAXVALUE ").append(" NO CYCLE ").append(" CACHE ").append(this.getPkCacheSize());
        return buf.toString();
    }
}

