/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.hsqldb;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.hsqldb.HSQLDBAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.resource.ResourceLocator;

public class HSQLDBNoSchemaAdapter
extends HSQLDBAdapter {
    public HSQLDBNoSchemaAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject ResourceLocator resourceLocator) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator);
    }

    @Override
    protected String getTableName(DbEntity entity) {
        return this.quotingStrategy.quotedIdentifier(entity, entity.getName());
    }

    @Override
    protected String getSchemaName(DbEntity entity) {
        return null;
    }

    @Override
    public Collection<String> dropTableStatements(DbEntity table) {
        return Collections.singleton("DROP TABLE " + this.getTableName(table));
    }

    @Override
    public String createTable(DbEntity ent) {
        String sql = super.createTable(ent);
        String fqnCreate = "CREATE CACHED TABLE " + super.getTableName(ent) + " (";
        if (sql != null && sql.toUpperCase().startsWith(fqnCreate)) {
            sql = "CREATE CACHED TABLE " + this.getTableName(ent) + " (" + sql.substring(fqnCreate.length());
        }
        return sql;
    }
}

