/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-lob.xml")
public class OracleAdapterIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private AdhocObjectFactory objectFactory;

    @Test
    public void testUpdatesLOBColumns() throws Exception {
        DataMap map = this.runtime.getDataDomain().getDataMap("lob");
        Assert.assertTrue((boolean)OracleAdapter.updatesLOBColumns(new InsertBatchQuery(map.getDbEntity("BLOB_TEST"), 1)));
        Assert.assertTrue((boolean)OracleAdapter.updatesLOBColumns(new InsertBatchQuery(map.getDbEntity("CLOB_TEST"), 1)));
        Assert.assertFalse((boolean)OracleAdapter.updatesLOBColumns(new InsertBatchQuery(map.getDbEntity("TEST"), 1)));
    }

    @Test
    public void testTimestampMapping() throws Exception {
        OracleAdapter adapter = (OracleAdapter)this.objectFactory.newInstance(OracleAdapter.class, OracleAdapter.class.getName());
        String[] types = adapter.externalTypesForJdbcType(93);
        Assert.assertNotNull((Object)types);
        Assert.assertEquals((long)1L, (long)types.length);
        Assert.assertEquals((Object)"TIMESTAMP", (Object)types[0]);
    }
}

