/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.util.ConversionUtil;

abstract class Evaluator {
    private static final ConcurrentMap<Class<?>, Evaluator> evaluators = new ConcurrentHashMap();
    private static final Evaluator NULL_LHS_EVALUATOR = new Evaluator(){

        @Override
        Integer compare(Object lhs, Object rhs) {
            return null;
        }

        @Override
        boolean eq(Object lhs, Object rhs) {
            return rhs == null;
        }
    };
    private static final Evaluator DEFAULT_EVALUATOR = new NonNullLhsEvaluator(new Evaluator(){

        @Override
        boolean eq(Object lhs, Object rhs) {
            return lhs.equals(rhs);
        }

        @Override
        Integer compare(Object lhs, Object rhs) {
            return null;
        }
    });
    private static final Evaluator PERSISTENT_EVALUATOR = new NonNullLhsEvaluator(new Evaluator(){

        @Override
        Integer compare(Object lhs, Object rhs) {
            return null;
        }

        @Override
        boolean eq(Object lhs, Object rhs) {
            Persistent lhsPersistent = (Persistent)lhs;
            if (rhs instanceof Persistent) {
                return lhsPersistent.getObjectId().equals(((Persistent)rhs).getObjectId());
            }
            if (rhs instanceof ObjectId) {
                return lhsPersistent.getObjectId().equals(rhs);
            }
            if (rhs instanceof Map) {
                return lhsPersistent.getObjectId().getIdSnapshot().equals(rhs);
            }
            if (lhsPersistent.getObjectId().getIdSnapshot().size() != 1) {
                return false;
            }
            if (rhs instanceof Number) {
                if (rhs instanceof Integer) {
                    return Cayenne.longPKForObject(lhsPersistent) == ((Number)rhs).longValue();
                }
                if (rhs instanceof Long) {
                    return Cayenne.longPKForObject(lhsPersistent) == ((Number)rhs).longValue();
                }
            }
            return Cayenne.pkForObject(lhsPersistent).equals(rhs);
        }
    });
    private static final Evaluator BIG_DECIMAL_EVALUATOR = new NonNullLhsEvaluator(new Evaluator(){

        @Override
        Integer compare(Object lhs, Object rhs) {
            return ((BigDecimal)lhs).compareTo(ConversionUtil.toBigDecimal(rhs));
        }

        @Override
        boolean eq(Object lhs, Object rhs) {
            Integer c = this.compare(lhs, rhs);
            return c != null && c == 0;
        }
    });
    private static final Evaluator COMPAREABLE_EVALUATOR = new NonNullLhsEvaluator(new Evaluator(){

        @Override
        Integer compare(Object lhs, Object rhs) {
            return ((Comparable)lhs).compareTo(ConversionUtil.toComparable(rhs));
        }

        @Override
        boolean eq(Object lhs, Object rhs) {
            return lhs.equals(rhs);
        }
    });

    Evaluator() {
    }

    static <T> Evaluator evaluator(Object lhs) {
        if (lhs == null) {
            return NULL_LHS_EVALUATOR;
        }
        Class<?> lhsType = lhs.getClass();
        Evaluator e = (Evaluator)evaluators.get(lhsType);
        if (e == null) {
            Evaluator created = Evaluator.compileEvaluator(lhsType);
            Evaluator existing = evaluators.putIfAbsent(lhsType, created);
            e = existing != null ? existing : created;
        }
        return e;
    }

    private static Evaluator compileEvaluator(Class<?> lhsType) {
        Evaluator ev = Evaluator.findInHierarchy(lhsType);
        if (ev != null) {
            return ev;
        }
        if (Persistent.class.isAssignableFrom(lhsType)) {
            return PERSISTENT_EVALUATOR;
        }
        if (BigDecimal.class.isAssignableFrom(lhsType)) {
            return BIG_DECIMAL_EVALUATOR;
        }
        if (Comparable.class.isAssignableFrom(lhsType)) {
            return COMPAREABLE_EVALUATOR;
        }
        return DEFAULT_EVALUATOR;
    }

    private static Evaluator findInHierarchy(Class<?> lhsType) {
        if (Object.class.equals(lhsType)) {
            return null;
        }
        Evaluator ev = (Evaluator)evaluators.get(lhsType);
        return ev != null ? ev : Evaluator.findInHierarchy(lhsType.getSuperclass());
    }

    abstract boolean eq(Object var1, Object var2);

    abstract Integer compare(Object var1, Object var2);

    static class NonNullLhsEvaluator
    extends Evaluator {
        final Evaluator delegate;

        NonNullLhsEvaluator(Evaluator delegate) {
            this.delegate = delegate;
        }

        @Override
        Integer compare(Object lhs, Object rhs) {
            if (rhs == null) {
                return 1;
            }
            return this.delegate.compare(lhs, rhs);
        }

        @Override
        boolean eq(Object lhs, Object rhs) {
            return rhs == null ? false : this.delegate.eq(lhs, rhs);
        }
    }
}

