/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.Collections;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.testdo.mt.ClientMtTable1;
import org.apache.cayenne.testdo.mt.MtTable1;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-multi-tier.xml")
public class ClientEntityResolverIT
extends ServerCase {
    @Inject
    private EntityResolver serverResolver;

    @Test
    public void testGetClientEntityResolver() {
        EntityResolver clientResolver = this.serverResolver.getClientEntityResolver();
        Assert.assertNotNull((Object)clientResolver);
        try {
            Assert.assertNotNull((Object)clientResolver.getObjEntity("MtTable1"));
        }
        catch (CayenneRuntimeException e) {
            Assert.fail((String)("'MtTable1' entity is not mapped. All entities: " + clientResolver.getObjEntities()));
        }
        Assert.assertNotNull((Object)clientResolver.getObjEntity(ClientMtTable1.class));
        Assert.assertNull((Object)clientResolver.getObjEntity(MtTable1.class));
    }

    @Test
    public void testConstructor() {
        ObjEntity entity = new ObjEntity("test_entity");
        entity.setClassName("java.lang.String");
        DataMap dataMap = new DataMap("test");
        dataMap.addObjEntity(entity);
        Set<DataMap> maps = Collections.singleton(dataMap);
        EntityResolver resolver = new EntityResolver(maps);
        Assert.assertSame((Object)entity, (Object)resolver.getObjEntity(entity.getName()));
        Assert.assertNotNull((Object)resolver.getObjEntity(entity.getName()));
    }

    @Test
    public void testInheritance() {
        ObjEntity superEntity = new ObjEntity("super_entity");
        superEntity.setClassName("java.lang.Object");
        ObjEntity subEntity = new ObjEntity("sub_entity");
        subEntity.setClassName("java.lang.String");
        subEntity.setSuperEntityName(superEntity.getName());
        try {
            subEntity.getSuperEntity();
            Assert.fail((String)"hmm... superentity can't possibly be resolved at this point.");
        }
        catch (CayenneRuntimeException e) {
            // empty catch block
        }
        DataMap dataMap = new DataMap("test");
        dataMap.addObjEntity(superEntity);
        dataMap.addObjEntity(subEntity);
        Set<DataMap> maps = Collections.singleton(dataMap);
        new EntityResolver(maps);
        Assert.assertSame((Object)superEntity, (Object)subEntity.getSuperEntity());
    }
}

