/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DbRelationshipIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    protected DbEntity artistEnt;
    protected DbEntity paintingEnt;
    protected DbEntity galleryEnt;

    @Before
    public void setUp() throws Exception {
        this.artistEnt = this.runtime.getDataDomain().getEntityResolver().getDbEntity("ARTIST");
        this.paintingEnt = this.runtime.getDataDomain().getEntityResolver().getDbEntity("PAINTING");
        this.galleryEnt = this.runtime.getDataDomain().getEntityResolver().getDbEntity("GALLERY");
    }

    @Test
    public void testSrcFkSnapshotWithTargetSnapshot() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Integer id = new Integer(44);
        map.put("GALLERY_ID", id);
        DbRelationship dbRel = this.galleryEnt.getRelationship("paintingArray");
        Map<String, Object> targetMap = dbRel.getReverseRelationship().srcFkSnapshotWithTargetSnapshot(map);
        Assert.assertEquals((Object)id, (Object)targetMap.get("GALLERY_ID"));
    }

    @Test
    public void testGetReverseRelationship1() throws Exception {
        DbRelationship r1 = this.artistEnt.getRelationship("paintingArray");
        DbRelationship r2 = r1.getReverseRelationship();
        Assert.assertNotNull((Object)r2);
        Assert.assertSame((Object)this.paintingEnt.getRelationship("toArtist"), (Object)r2);
    }

    @Test
    public void testGetReverseRelationship2() throws Exception {
        DbRelationship r1 = this.paintingEnt.getRelationship("toArtist");
        DbRelationship r2 = r1.getReverseRelationship();
        Assert.assertNotNull((Object)r2);
        Assert.assertSame((Object)this.artistEnt.getRelationship("paintingArray"), (Object)r2);
    }

    @Test
    public void testGetReverseRelationshipToSelf() {
        DataMap namespace = new DataMap();
        DbEntity e = new DbEntity("test");
        namespace.addDbEntity(e);
        DbRelationship rforward = new DbRelationship("rforward");
        e.addRelationship(rforward);
        rforward.setSourceEntity(e);
        rforward.setTargetEntityName(e);
        Assert.assertNull((Object)rforward.getReverseRelationship());
        e.addAttribute(new DbAttribute("a1"));
        e.addAttribute(new DbAttribute("a2"));
        rforward.addJoin(new DbJoin(rforward, "a1", "a2"));
        Assert.assertNull((Object)rforward.getReverseRelationship());
        DbRelationship rback = new DbRelationship("rback");
        e.addRelationship(rback);
        rback.setSourceEntity(e);
        rback.setTargetEntityName(e);
        Assert.assertNull((Object)rforward.getReverseRelationship());
        rback.addJoin(new DbJoin(rback, "a2", "a1"));
        Assert.assertSame((Object)rback, (Object)rforward.getReverseRelationship());
        Assert.assertSame((Object)rforward, (Object)rback.getReverseRelationship());
    }
}

