/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorFactory;
import org.apache.cayenne.reflect.LazyClassDescriptorDecorator;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

@UseServerRuntime(value="cayenne-multi-tier.xml")
public class EntityResolverClassDescriptorIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testServerDescriptorCaching() {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        resolver.getClassDescriptorMap().clearDescriptors();
        ClassDescriptor descriptor = resolver.getClassDescriptor("MtTable1");
        Assert.assertNotNull((Object)descriptor);
        Assert.assertSame((Object)descriptor, (Object)resolver.getClassDescriptor("MtTable1"));
        resolver.getClassDescriptorMap().clearDescriptors();
        ClassDescriptor descriptor1 = resolver.getClassDescriptor("MtTable1");
        Assert.assertNotNull((Object)descriptor1);
        Assert.assertNotSame((Object)descriptor, (Object)descriptor1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerDescriptorFactory() {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        resolver.getClassDescriptorMap().clearDescriptors();
        ClassDescriptor descriptor = (ClassDescriptor)Mockito.mock(ClassDescriptor.class);
        ClassDescriptorFactory factory = (ClassDescriptorFactory)Mockito.mock(ClassDescriptorFactory.class);
        Mockito.when((Object)factory.getDescriptor("MtTable1")).thenReturn((Object)descriptor);
        resolver.getClassDescriptorMap().addFactory(factory);
        try {
            ClassDescriptor resolved = resolver.getClassDescriptor("MtTable1");
            Assert.assertNotNull((Object)resolved);
            resolved = ((LazyClassDescriptorDecorator)resolved).getDescriptor();
            Assert.assertSame((Object)descriptor, (Object)resolved);
        }
        finally {
            resolver.getClassDescriptorMap().removeFactory(factory);
        }
    }

    @Test
    public void testArcProperties() {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        resolver.getClassDescriptorMap().clearDescriptors();
        ClassDescriptor descriptor = resolver.getClassDescriptor("MtTable1");
        Assert.assertNotNull((Object)descriptor);
        PropertyDescriptor p = descriptor.getProperty("table2Array");
        Assert.assertTrue((boolean)(p instanceof ArcProperty));
        ClassDescriptor target = ((ArcProperty)p).getTargetDescriptor();
        Assert.assertNotNull((Object)target);
        Assert.assertSame((Object)resolver.getClassDescriptor("MtTable2"), (Object)target);
        Assert.assertNotNull((Object)((ArcProperty)p).getComplimentaryReverseArc());
        Assert.assertEquals((Object)"table1", (Object)((ArcProperty)p).getComplimentaryReverseArc().getName());
    }
}

