/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.map.ClientObjRelationship;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.DeleteRule;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.ToStringBuilder;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;

public class ObjRelationship
extends Relationship
implements ConfigurationNode {
    public static final String DEFAULT_COLLECTION_TYPE = "java.util.List";
    boolean readOnly;
    protected int deleteRule = 0;
    protected boolean usedForLocking;
    protected List<DbRelationship> dbRelationships = new ArrayList<DbRelationship>(2);
    String deferredPath;
    protected String collectionType;
    protected String mapKey;

    public ObjRelationship() {
        this(null);
    }

    public ObjRelationship(String name) {
        super(name);
    }

    @Override
    public ObjEntity getSourceEntity() {
        return (ObjEntity)super.getSourceEntity();
    }

    @Override
    public <T> T acceptVisitor(ConfigurationNodeVisitor<T> visitor) {
        return visitor.visitObjRelationship(this);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        String path;
        ObjEntity source = this.getSourceEntity();
        if (source == null) {
            return;
        }
        encoder.print("<obj-relationship name=\"" + this.getName());
        encoder.print("\" source=\"" + source.getName());
        ObjEntity target = this.getTargetEntity();
        if (target != null) {
            encoder.print("\" target=\"" + target.getName());
        }
        if (this.getCollectionType() != null && !DEFAULT_COLLECTION_TYPE.equals(this.getCollectionType())) {
            encoder.print("\" collection-type=\"" + this.getCollectionType());
        }
        if (this.getMapKey() != null) {
            encoder.print("\" map-key=\"" + this.getMapKey());
        }
        if (this.isUsedForLocking()) {
            encoder.print("\" lock=\"true");
        }
        String deleteRule = DeleteRule.deleteRuleName(this.getDeleteRule());
        if (this.getDeleteRule() != 0 && deleteRule != null) {
            encoder.print("\" deleteRule=\"" + deleteRule);
        }
        if ((path = this.getValidRelationshipPath()) != null) {
            encoder.print("\" db-relationship-path=\"" + path);
        }
        encoder.println("\"/>");
    }

    @Override
    public ObjEntity getTargetEntity() {
        String targetName = this.getTargetEntityName();
        if (targetName == null) {
            return null;
        }
        return this.getNonNullNamespace().getObjEntity(targetName);
    }

    public String getReverseRelationshipName() {
        ObjRelationship reverse = this.getReverseRelationship();
        return reverse != null ? reverse.getName() : null;
    }

    @Override
    public ObjRelationship getReverseRelationship() {
        List<DbRelationship> relationships = this.getDbRelationships();
        ArrayList<DbRelationship> reversed = new ArrayList<DbRelationship>(relationships.size());
        for (DbRelationship relationship : relationships) {
            DbRelationship reverse = relationship.getReverseRelationship();
            if (reverse == null) {
                return null;
            }
            reversed.add(0, reverse);
        }
        ObjEntity target = this.getTargetEntity();
        if (target == null) {
            return null;
        }
        ObjEntity source = this.getSourceEntity();
        for (ObjRelationship relationship : target.getRelationships()) {
            if (relationship.getTargetEntity() != source) continue;
            List<DbRelationship> otherRels = relationship.getDbRelationships();
            if (reversed.size() != otherRels.size()) continue;
            int len = reversed.size();
            boolean relsMatch = true;
            for (int i = 0; i < len; ++i) {
                if (otherRels.get(i) == reversed.get(i)) continue;
                relsMatch = false;
                break;
            }
            if (!relsMatch) continue;
            return relationship;
        }
        return null;
    }

    public ObjRelationship createReverseRelationship() {
        ObjRelationship reverse = new ObjRelationship();
        reverse.setSourceEntity(this.getTargetEntity());
        reverse.setTargetEntityName(this.getSourceEntity().getName());
        reverse.setDbRelationshipPath(this.getReverseDbRelationshipPath());
        return reverse;
    }

    public List<DbRelationship> getDbRelationships() {
        this.refreshFromDeferredPath();
        return Collections.unmodifiableList(this.dbRelationships);
    }

    public void addDbRelationship(DbRelationship dbRel) {
        DbRelationship lastRel;
        this.refreshFromDeferredPath();
        if (dbRel.getName() == null) {
            throw new IllegalArgumentException("DbRelationship has no name");
        }
        int numDbRelationships = this.dbRelationships.size();
        if (numDbRelationships > 0 && !(lastRel = this.dbRelationships.get(numDbRelationships - 1)).getTargetEntityName().equals(dbRel.getSourceEntity().getName())) {
            throw new CayenneRuntimeException("Error adding db relationship " + dbRel + " to ObjRelationship " + this + " because the source of the newly added relationship " + "is not the target of the previous relationship " + "in the chain", new Object[0]);
        }
        this.dbRelationships.add(dbRel);
        this.recalculateReadOnlyValue();
        this.recalculateToManyValue();
    }

    public void removeDbRelationship(DbRelationship dbRel) {
        this.refreshFromDeferredPath();
        if (this.dbRelationships.remove(dbRel)) {
            this.recalculateReadOnlyValue();
            this.recalculateToManyValue();
        }
    }

    public void clearDbRelationships() {
        this.deferredPath = null;
        this.dbRelationships.clear();
        this.readOnly = false;
        this.toMany = false;
    }

    public boolean isOptional() {
        if (this.isToMany() || this.isFlattened()) {
            return true;
        }
        if (this.isQualifiedEntity(this.getTargetEntity())) {
            return true;
        }
        DbRelationship dbRelationship = this.getDbRelationships().get(0);
        if (dbRelationship.isToPK()) {
            if (!dbRelationship.isFromPK()) {
                return false;
            }
            DbRelationship reverseRelationship = dbRelationship.getReverseRelationship();
            if (reverseRelationship.isToDependentPK()) {
                return false;
            }
        }
        return true;
    }

    public boolean isSourceDefiningTargetPrecenseAndType(EntityResolver entityResolver) {
        if (this.isOptional()) {
            return false;
        }
        EntityInheritanceTree inheritanceTree = entityResolver.getInheritanceTree(this.getTargetEntityName());
        return inheritanceTree == null || inheritanceTree.getChildren().isEmpty();
    }

    private boolean isQualifiedEntity(ObjEntity entity) {
        if (entity.getDeclaredQualifier() != null) {
            return true;
        }
        if ((entity = entity.getSuperEntity()) == null) {
            return false;
        }
        return this.isQualifiedEntity(entity);
    }

    public boolean isSourceIndependentFromTargetChange() {
        return this.isToMany() || this.isFlattened() || this.isToDependentEntity() || !this.isToPK();
    }

    public boolean isToDependentEntity() {
        return this.getDbRelationships().get(0).isToDependentPK();
    }

    public boolean isToPK() {
        return this.getDbRelationships().get(0).isToPK();
    }

    public boolean isFlattened() {
        return this.getDbRelationships().size() > 1;
    }

    public boolean isReadOnly() {
        this.refreshFromDeferredPath();
        this.recalculateReadOnlyValue();
        return this.readOnly;
    }

    @Override
    public boolean isToMany() {
        this.refreshFromDeferredPath();
        this.recalculateToManyValue();
        return super.isToMany();
    }

    public int getDeleteRule() {
        return this.deleteRule;
    }

    public void setDeleteRule(int value) {
        if (value != 2 && value != 3 && value != 1 && value != 0) {
            throw new IllegalArgumentException("Delete rule value " + value + " is not a constant from the DeleteRule class");
        }
        this.deleteRule = value;
    }

    public boolean isUsedForLocking() {
        return this.usedForLocking;
    }

    public void setUsedForLocking(boolean usedForLocking) {
        this.usedForLocking = usedForLocking;
    }

    public String getDbRelationshipPath() {
        this.refreshFromDeferredPath();
        if (this.getDbRelationships().isEmpty()) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        Iterator<DbRelationship> it = this.getDbRelationships().iterator();
        while (it.hasNext()) {
            DbRelationship next = it.next();
            path.append(next.getName());
            if (!it.hasNext()) continue;
            path.append(".");
        }
        return path.toString();
    }

    public String getReverseDbRelationshipPath() throws ExpressionException {
        List<DbRelationship> relationships = this.getDbRelationships();
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        ListIterator<DbRelationship> it = relationships.listIterator(relationships.size());
        while (it.hasPrevious()) {
            DbRelationship relationship = it.previous();
            DbRelationship reverse = relationship.getReverseRelationship();
            if (reverse == null) {
                throw new CayenneRuntimeException("No reverse relationship exist for " + relationship, new Object[0]);
            }
            if (buffer.length() > 0) {
                buffer.append(".");
            }
            buffer.append(reverse.getName());
        }
        return buffer.toString();
    }

    public void setDbRelationshipPath(String relationshipPath) {
        if (!Util.nullSafeEquals(this.getDbRelationshipPath(), relationshipPath)) {
            this.refreshFromPath(relationshipPath, false);
        }
    }

    void setDeferredDbRelationshipPath(String relationshipPath) {
        if (!Util.nullSafeEquals(this.getDbRelationshipPath(), relationshipPath)) {
            this.deferredPath = relationshipPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshFromDeferredPath() {
        if (this.deferredPath != null) {
            ObjRelationship objRelationship = this;
            synchronized (objRelationship) {
                if (this.deferredPath != null) {
                    this.refreshFromPath(this.deferredPath, true);
                    this.deferredPath = null;
                }
            }
        }
    }

    String getValidRelationshipPath() {
        String path = this.getDbRelationshipPath();
        if (path == null) {
            return null;
        }
        ObjEntity entity = this.getSourceEntity();
        if (entity == null) {
            throw new CayenneRuntimeException("Can't resolve DbRelationships, null source ObjEntity", new Object[0]);
        }
        DbEntity dbEntity = entity.getDbEntity();
        if (dbEntity == null) {
            return null;
        }
        StringBuilder validPath = new StringBuilder();
        try {
            for (PathComponent<DbAttribute, DbRelationship> pathComponent : dbEntity.resolvePath(new ASTDbPath(path), Collections.emptyMap())) {
                if (validPath.length() > 0) {
                    validPath.append(".");
                }
                validPath.append(pathComponent.getName());
            }
        }
        catch (ExpressionException ex) {
            // empty catch block
        }
        return validPath.toString();
    }

    final void refreshFromPath(String dbRelationshipPath, boolean stripInvalid) {
        block5: {
            this.dbRelationships.clear();
            if (dbRelationshipPath != null) {
                ObjEntity entity = this.getSourceEntity();
                if (entity == null) {
                    throw new CayenneRuntimeException("Can't resolve DbRelationships, null source ObjEntity", new Object[0]);
                }
                try {
                    Iterator<CayenneMapEntry> it = entity.resolvePathComponents(new ASTDbPath(dbRelationshipPath));
                    while (it.hasNext()) {
                        DbRelationship relationship = (DbRelationship)it.next();
                        this.dbRelationships.add(relationship);
                    }
                }
                catch (ExpressionException ex) {
                    if (stripInvalid) break block5;
                    throw ex;
                }
            }
        }
        this.recalculateToManyValue();
        this.recalculateReadOnlyValue();
    }

    public void recalculateToManyValue() {
        for (DbRelationship thisRel : this.dbRelationships) {
            if (!thisRel.isToMany()) continue;
            this.toMany = true;
            return;
        }
        this.toMany = false;
    }

    public void recalculateReadOnlyValue() {
        if (this.dbRelationships.size() < 2) {
            this.readOnly = false;
            return;
        }
        if (this.dbRelationships.size() > 2) {
            this.readOnly = true;
            return;
        }
        DbRelationship firstRel = this.dbRelationships.get(0);
        DbRelationship secondRel = this.dbRelationships.get(1);
        if (!secondRel.isToMany()) {
            if (!secondRel.isToPK()) {
                this.readOnly = true;
                return;
            }
            DbRelationship firstReverseRel = firstRel.getReverseRelationship();
            if (firstReverseRel == null || !firstReverseRel.isToPK()) {
                this.readOnly = true;
                return;
            }
            this.readOnly = false;
        } else {
            this.readOnly = true;
        }
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("name", this.getName()).append("sourceEntityName", this.getSourceEntity().getName()).append("targetEntityName", this.getTargetEntityName()).append("dbRelationshipPath", this.getDbRelationshipPath()).toString();
    }

    public ObjRelationship getClientRelationship() {
        ObjRelationship reverse = this.getReverseRelationship();
        String reverseName = reverse != null ? reverse.getName() : null;
        ClientObjRelationship relationship = new ClientObjRelationship(this.getName(), reverseName, this.isToMany(), this.isReadOnly());
        relationship.setTargetEntityName(this.getTargetEntityName());
        relationship.setDeleteRule(this.getDeleteRule());
        relationship.setCollectionType(this.getCollectionType());
        return relationship;
    }

    public String getCollectionType() {
        if (this.collectionType != null) {
            return this.collectionType;
        }
        return this.isToMany() ? DEFAULT_COLLECTION_TYPE : null;
    }

    public void setCollectionType(String collectionType) {
        this.collectionType = collectionType;
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public void setMapKey(String mapKey) {
        this.mapKey = mapKey;
    }

    @Override
    public boolean isMandatory() {
        this.refreshFromDeferredPath();
        if (this.dbRelationships.size() == 0) {
            return false;
        }
        return this.dbRelationships.get(0).isMandatory();
    }
}

