/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.SQLTemplateBuilder;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.junit.Assert;
import org.junit.Test;

public class SQLTemplateBuilderTest {
    @Test
    public void testGetQueryType() throws Exception {
        MockupRootQueryBuilder builder = new MockupRootQueryBuilder();
        Assert.assertTrue((boolean)(builder.getQuery() instanceof SQLTemplate));
    }

    @Test
    public void testGetQueryName() throws Exception {
        MockupRootQueryBuilder builder = new MockupRootQueryBuilder();
        builder.setName("xyz");
        Assert.assertEquals((Object)"xyz", (Object)builder.getQuery().getName());
    }

    @Test
    public void testGetQueryRoot() throws Exception {
        DataMap map = new DataMap();
        ObjEntity entity = new ObjEntity("A");
        map.addObjEntity(entity);
        SQLTemplateBuilder builder = new SQLTemplateBuilder();
        builder.setRoot(map, "obj-entity", "A");
        Query query = builder.getQuery();
        Assert.assertTrue((boolean)(query instanceof SQLTemplate));
        Assert.assertSame((Object)entity, (Object)((SQLTemplate)query).getRoot());
    }

    @Test
    public void testGetQueryProperties() throws Exception {
        MockupRootQueryBuilder builder = new MockupRootQueryBuilder();
        builder.addProperty("cayenne.GenericSelectQuery.fetchLimit", "5");
        builder.addProperty("cayenne.GenericSelectQuery.statementFetchSize", "6");
        Query query = builder.getQuery();
        Assert.assertTrue((boolean)(query instanceof SQLTemplate));
        Assert.assertEquals((long)5L, (long)((SQLTemplate)query).getFetchLimit());
        Assert.assertEquals((long)6L, (long)((SQLTemplate)query).getStatementFetchSize());
    }

    @Test
    public void testGetQuerySql() throws Exception {
        MockupRootQueryBuilder builder = new MockupRootQueryBuilder();
        builder.addSql("abc", null);
        SQLTemplate query = (SQLTemplate)builder.getQuery();
        Assert.assertEquals((Object)"abc", (Object)query.getDefaultTemplate());
    }

    @Test
    public void testGetQueryAdapterSql() throws Exception {
        MockupRootQueryBuilder builder = new MockupRootQueryBuilder();
        builder.addSql("abc", "adapter");
        SQLTemplate query = (SQLTemplate)builder.getQuery();
        Assert.assertNull((Object)query.getDefaultTemplate());
        Assert.assertEquals((Object)"abc", (Object)query.getTemplate("adapter"));
    }

    class MockupRootQueryBuilder
    extends SQLTemplateBuilder {
        MockupRootQueryBuilder() {
        }

        @Override
        public Object getRoot() {
            return "FakeRoot";
        }
    }
}

