/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map.naming;

import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.naming.NameChecker;
import org.apache.commons.lang.StringUtils;

public enum NameCheckers implements NameChecker
{
    dataChannelDescriptor("project"){

        @Override
        public boolean isNameInUse(Object namingContext, String name) {
            return false;
        }
    }
    ,
    dataMap("datamap"){

        @Override
        public boolean isNameInUse(Object namingContext, String name) {
            if (namingContext == null) {
                return false;
            }
            if (namingContext instanceof DataDomain) {
                DataDomain domain = (DataDomain)namingContext;
                return domain.getDataMap(name) != null;
            }
            if (namingContext instanceof DataChannelDescriptor) {
                DataChannelDescriptor domain = (DataChannelDescriptor)namingContext;
                return domain.getDataMap(name) != null;
            }
            return false;
        }
    }
    ,
    objEntity("ObjEntity"){

        @Override
        public boolean isNameInUse(Object namingContext, String name) {
            DataMap map = (DataMap)namingContext;
            return map.getObjEntity(name) != null;
        }
    }
    ,
    embeddable("Embeddable"){

        @Override
        public boolean isNameInUse(Object namingContext, String name) {
            DataMap map = (DataMap)namingContext;
            return map.getEmbeddable(map.getNameWithDefaultPackage(name)) != null;
        }
    }
    ,
    embeddableAttribute("untitledAttr"){

        @Override
        public boolean isNameInUse(Object namingContext, String name) {
            Embeddable emb = (Embeddable)namingContext;
            return emb.getAttribute(name) != null;
        }
    }
    ,
    dbEntity("db_entity"){

        @Override
        public boolean isNameInUse(Object namingContext, String name) {
            DataMap map = (DataMap)namingContext;
            return map.getDbEntity(name) != null;
        }
    }
    ,
    procedureParameter("UntitledProcedureParameter"){

        @Override
        public boolean isNameInUse(Object namingContext, String name) {
            Procedure procedure = (Procedure)namingContext;
            for (ProcedureParameter parameter : procedure.getCallParameters()) {
                if (!name.equals(parameter.getName())) continue;
                return true;
            }
            return false;
        }
    }
    ,
    procedure("procedure"){

        @Override
        public boolean isNameInUse(Object namingContext, String name) {
            DataMap map = (DataMap)namingContext;
            return map.getProcedure(name) != null;
        }
    }
    ,
    query("query"){

        @Override
        public boolean isNameInUse(Object namingContext, String name) {
            DataMap map = (DataMap)namingContext;
            return map.getQuery(name) != null;
        }
    }
    ,
    objAttribute("untitledAttr"){

        @Override
        public boolean isNameInUse(Object namingContext, String name) {
            return objRelationship.isNameInUse(namingContext, name);
        }
    }
    ,
    dbAttribute("untitledAttr"){

        @Override
        public boolean isNameInUse(Object namingContext, String name) {
            Entity ent = (Entity)namingContext;
            return ent.getAttribute(name) != null || ent.getRelationship(name) != null;
        }
    }
    ,
    dataNodeDescriptor("datanode"){

        @Override
        public boolean isNameInUse(Object namingContext, String name) {
            DataChannelDescriptor domain = (DataChannelDescriptor)namingContext;
            for (DataNodeDescriptor dataNodeDescriptor : domain.getNodeDescriptors()) {
                if (!dataNodeDescriptor.getName().equals(name)) continue;
                return true;
            }
            return false;
        }
    }
    ,
    objRelationship("untitledRel"){

        @Override
        public boolean isNameInUse(Object namingContext, String name) {
            ObjEntity ent = (ObjEntity)namingContext;
            return dbAttribute.isNameInUse(namingContext, name) || ent.getCallbackMethods().contains("get" + StringUtils.capitalize((String)name));
        }
    }
    ,
    dbRelationship("untitledRel"){

        @Override
        public boolean isNameInUse(Object namingContext, String name) {
            return dbAttribute.isNameInUse(namingContext, name);
        }
    }
    ,
    objCallbackMethod("ObjCallbackMethod"){

        @Override
        public boolean isNameInUse(Object namingContext, String name) {
            ObjEntity ent = (ObjEntity)namingContext;
            return name.startsWith("get") && dbAttribute.isNameInUse(namingContext, StringUtils.uncapitalize((String)name.substring(3))) || ent.getCallbackMethods().contains(name);
        }
    };

    public final String baseName;

    private NameCheckers(String baseName) {
        this.baseName = baseName;
    }

    @Override
    public String baseName() {
        return this.baseName;
    }
}

