/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class AddRelationshipToDb
extends AbstractToDbToken.Entity {
    private DbRelationship rel;

    public AddRelationshipToDb(DbEntity entity, DbRelationship rel) {
        super("Add foreign key", entity);
        this.rel = rel;
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        String fksql;
        if (this.shouldGenerateFkConstraint() && (fksql = adapter.createFkConstraint(this.rel)) != null) {
            return Collections.singletonList(fksql);
        }
        return Collections.emptyList();
    }

    public boolean shouldGenerateFkConstraint() {
        return !this.rel.isToMany() && this.rel.isToPK() && !this.rel.isToDependentPK();
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createDropRelationshipToModel(this.getEntity(), this.rel);
    }

    @Override
    public String getTokenValue() {
        if (this.shouldGenerateFkConstraint()) {
            return this.rel.getSourceEntity().getName() + "->" + this.rel.getTargetEntityName();
        }
        return "Skip. No sql representation.";
    }

    public DbRelationship getRelationship() {
        return this.rel;
    }

    @Override
    public int compareTo(MergerToken o) {
        if (o instanceof AddRelationshipToDb) {
            return super.compareTo(o);
        }
        return 1;
    }
}

