/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.List;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.merge.DropColumnToModel;
import org.apache.cayenne.merge.DropRelationshipToModel;
import org.apache.cayenne.merge.MergeCase;
import org.apache.cayenne.merge.MergerToken;
import org.junit.Assert;
import org.junit.Test;

public class DropRelationshipToModelIT
extends MergeCase {
    @Test
    public void testForeignKey() throws Exception {
        this.dropTableIfPresent("NEW_TABLE");
        this.dropTableIfPresent("NEW_TABLE2");
        this.assertTokensAndExecute(0, 0);
        DbEntity dbEntity1 = new DbEntity("NEW_TABLE");
        DbAttribute e1col1 = new DbAttribute("ID", 4, dbEntity1);
        e1col1.setMandatory(true);
        e1col1.setPrimaryKey(true);
        dbEntity1.addAttribute(e1col1);
        DbAttribute e1col2 = new DbAttribute("NAME", 12, dbEntity1);
        e1col2.setMaxLength(10);
        e1col2.setMandatory(false);
        dbEntity1.addAttribute(e1col2);
        this.map.addDbEntity(dbEntity1);
        DbEntity dbEntity2 = new DbEntity("NEW_TABLE2");
        DbAttribute e2col1 = new DbAttribute("ID", 4, dbEntity2);
        e2col1.setMandatory(true);
        e2col1.setPrimaryKey(true);
        dbEntity2.addAttribute(e2col1);
        DbAttribute e2col2 = new DbAttribute("FK", 4, dbEntity2);
        dbEntity2.addAttribute(e2col2);
        DbAttribute e2col3 = new DbAttribute("NAME", 12, dbEntity2);
        e2col3.setMaxLength(10);
        dbEntity2.addAttribute(e2col3);
        this.map.addDbEntity(dbEntity2);
        DbRelationship rel1To2 = new DbRelationship("rel1To2");
        rel1To2.setSourceEntity(dbEntity1);
        rel1To2.setTargetEntityName(dbEntity2);
        rel1To2.setToMany(true);
        rel1To2.addJoin(new DbJoin(rel1To2, e1col1.getName(), e2col2.getName()));
        dbEntity1.addRelationship(rel1To2);
        DbRelationship rel2To1 = new DbRelationship("rel2To1");
        rel2To1.setSourceEntity(dbEntity2);
        rel2To1.setTargetEntityName(dbEntity1);
        rel2To1.setToMany(false);
        rel2To1.addJoin(new DbJoin(rel2To1, e2col2.getName(), e1col1.getName()));
        dbEntity2.addRelationship(rel2To1);
        Assert.assertSame((Object)rel1To2, (Object)rel2To1.getReverseRelationship());
        Assert.assertSame((Object)rel2To1, (Object)rel1To2.getReverseRelationship());
        this.assertTokensAndExecute(4, 0);
        this.assertTokensAndExecute(0, 0);
        ObjEntity objEntity1 = new ObjEntity("NewTable");
        objEntity1.setDbEntity(dbEntity1);
        ObjAttribute oatr1 = new ObjAttribute("name");
        oatr1.setDbAttributePath(e1col2.getName());
        oatr1.setType("java.lang.String");
        objEntity1.addAttribute(oatr1);
        this.map.addObjEntity(objEntity1);
        ObjEntity objEntity2 = new ObjEntity("NewTable2");
        objEntity2.setDbEntity(dbEntity2);
        ObjAttribute o2a1 = new ObjAttribute("name");
        o2a1.setDbAttributePath(e2col3.getName());
        o2a1.setType("java.lang.String");
        objEntity2.addAttribute(o2a1);
        this.map.addObjEntity(objEntity2);
        Assert.assertEquals((long)0L, (long)objEntity1.getRelationships().size());
        Assert.assertEquals((long)0L, (long)objEntity2.getRelationships().size());
        ObjRelationship objRel1To2 = new ObjRelationship("objRel1To2");
        objRel1To2.addDbRelationship(rel1To2);
        objRel1To2.setSourceEntity(objEntity1);
        objRel1To2.setTargetEntityName(objEntity2);
        objEntity1.addRelationship(objRel1To2);
        ObjRelationship objRel2To1 = new ObjRelationship("objRel2To1");
        objRel2To1.addDbRelationship(rel2To1);
        objRel2To1.setSourceEntity(objEntity2);
        objRel2To1.setTargetEntityName(objEntity1);
        objEntity2.addRelationship(objRel2To1);
        Assert.assertEquals((long)1L, (long)objEntity1.getRelationships().size());
        Assert.assertEquals((long)1L, (long)objEntity2.getRelationships().size());
        Assert.assertSame((Object)objRel1To2, (Object)objRel2To1.getReverseRelationship());
        Assert.assertSame((Object)objRel2To1, (Object)objRel1To2.getReverseRelationship());
        dbEntity2.removeRelationship(rel2To1.getName());
        dbEntity1.removeRelationship(rel1To2.getName());
        dbEntity2.removeAttribute(e2col2.getName());
        List<MergerToken> tokens = this.createMergeTokens();
        this.assertTokens(tokens, 2, 1);
        for (MergerToken token : tokens) {
            if (!token.getDirection().isToDb()) continue;
            this.execute(token);
        }
        this.assertTokensAndExecute(0, 0);
        dbEntity2.addRelationship(rel2To1);
        dbEntity1.addRelationship(rel1To2);
        dbEntity2.addAttribute(e2col2);
        tokens = this.createMergeTokens();
        this.assertTokens(tokens, 2, 0);
        MergerToken token0 = tokens.get(0).createReverse(this.mergerFactory());
        MergerToken token1 = tokens.get(1).createReverse(this.mergerFactory());
        if (!(token0 instanceof DropRelationshipToModel && token1 instanceof DropColumnToModel || token1 instanceof DropRelationshipToModel && token0 instanceof DropColumnToModel)) {
            Assert.fail();
        }
        this.execute(token0);
        this.execute(token1);
        Assert.assertNull((Object)dbEntity2.getAttribute(e2col2.getName()));
        Assert.assertEquals((long)0L, (long)dbEntity1.getRelationships().size());
        Assert.assertEquals((long)0L, (long)dbEntity2.getRelationships().size());
        Assert.assertEquals((long)0L, (long)objEntity1.getRelationships().size());
        Assert.assertEquals((long)0L, (long)objEntity2.getRelationships().size());
        dbEntity1.removeRelationship(rel1To2.getName());
        dbEntity2.removeRelationship(rel2To1.getName());
        this.map.removeObjEntity(objEntity1.getName(), true);
        this.map.removeDbEntity(dbEntity1.getName(), true);
        this.map.removeObjEntity(objEntity2.getName(), true);
        this.map.removeDbEntity(dbEntity2.getName(), true);
        this.resolver.refreshMappingCache();
        Assert.assertNull((Object)this.map.getObjEntity(objEntity1.getName()));
        Assert.assertNull((Object)this.map.getDbEntity(dbEntity1.getName()));
        Assert.assertNull((Object)this.map.getObjEntity(objEntity2.getName()));
        Assert.assertNull((Object)this.map.getDbEntity(dbEntity2.getName()));
        Assert.assertFalse((boolean)this.map.getDbEntities().contains(dbEntity1));
        Assert.assertFalse((boolean)this.map.getDbEntities().contains(dbEntity2));
        this.assertTokensAndExecute(2, 0);
        this.assertTokensAndExecute(0, 0);
    }
}

