/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.loader.DbLoaderConfiguration;
import org.apache.cayenne.access.loader.filters.DbPath;
import org.apache.cayenne.access.loader.filters.EntityFilters;
import org.apache.cayenne.access.loader.filters.FilterFactory;
import org.apache.cayenne.access.loader.filters.FiltersConfig;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.DbMerger;
import org.apache.cayenne.merge.ExecutingMergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.merge.ValueForNullProvider;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;

@UseServerRuntime(value="cayenne-testmap.xml")
public abstract class MergeCase
extends ServerCase {
    private Log logger = LogFactory.getLog(MergeCase.class);
    @Inject
    private DBHelper dbHelper;
    @Inject
    private ServerRuntime runtime;
    @Inject
    private UnitDbAdapter accessStackAdapter;
    @Inject
    private ServerCaseDataSourceFactory dataSourceFactory;
    @Inject
    protected EntityResolver resolver;
    @Inject
    protected DataNode node;
    protected DataMap map;

    @Override
    public void cleanUpDB() throws Exception {
        this.dbHelper.update("ARTGROUP").set("PARENT_GROUP_ID", null, 4).execute();
        super.cleanUpDB();
    }

    @Before
    public void setUp() throws Exception {
        this.map = this.runtime.getDataDomain().getDataMap("testmap");
        this.filterDataMap();
        List<MergerToken> tokens = this.createMergeTokens();
        this.execute(tokens);
        this.assertTokensAndExecute(0, 0);
    }

    protected DbMerger createMerger(MergerFactory mergerFactory) {
        return this.createMerger(mergerFactory, null);
    }

    protected DbMerger createMerger(MergerFactory mergerFactory, ValueForNullProvider valueForNullProvider) {
        return new DbMerger(mergerFactory, valueForNullProvider);
    }

    protected List<MergerToken> createMergeTokens() {
        DbLoaderConfiguration loaderConfiguration = new DbLoaderConfiguration();
        loaderConfiguration.setFiltersConfig(new FiltersConfig(new EntityFilters(DbPath.EMPTY, FilterFactory.include("ARTIST|GALLERY|PAINTING|NEW_TABLE2?"), FilterFactory.TRUE, FilterFactory.NULL)));
        return this.createMerger(this.node.getAdapter().mergerFactory()).createMergeTokens(this.node.getDataSource(), this.node.getAdapter(), this.map, loaderConfiguration);
    }

    private void filterDataMap() {
        boolean excludeBinPK = this.accessStackAdapter.supportsBinaryPK();
        if (!excludeBinPK) {
            return;
        }
        ArrayList<DbEntity> entitiesToRemove = new ArrayList<DbEntity>();
        block0: for (DbEntity ent : this.map.getDbEntities()) {
            for (DbAttribute attr : ent.getAttributes()) {
                if (attr.getType() != -2 && attr.getType() != -3 && attr.getType() != -4 || !attr.isPrimaryKey() && !attr.isForeignKey()) continue;
                entitiesToRemove.add(ent);
                continue block0;
            }
        }
        for (DbEntity e : entitiesToRemove) {
            this.map.removeDbEntity(e.getName(), true);
        }
    }

    protected void execute(List<MergerToken> tokens) {
        ExecutingMergerContext mergerContext = new ExecutingMergerContext(this.map, this.node);
        for (MergerToken tok : tokens) {
            tok.execute(mergerContext);
        }
    }

    protected void execute(MergerToken token) throws Exception {
        ExecutingMergerContext mergerContext = new ExecutingMergerContext(this.map, this.node);
        token.execute(mergerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSql(String sql) throws Exception {
        Connection conn = this.dataSourceFactory.getSharedDataSource().getConnection();
        try {
            Statement st = conn.createStatement();
            try {
                st.execute(sql);
            }
            finally {
                st.close();
            }
        }
        finally {
            conn.close();
        }
    }

    protected void assertTokens(List<MergerToken> tokens, int expectedToDb, int expectedToModel) {
        int actualToDb = 0;
        int actualToModel = 0;
        for (MergerToken token : tokens) {
            if (token.getDirection().isToDb()) {
                ++actualToDb;
                continue;
            }
            if (!token.getDirection().isToModel()) continue;
            ++actualToModel;
        }
        Assert.assertEquals((String)"tokens to db", (long)expectedToDb, (long)actualToDb);
        Assert.assertEquals((String)"tokens to model", (long)expectedToModel, (long)actualToModel);
    }

    protected void assertTokensAndExecute(int expectedToDb, int expectedToModel) {
        List<MergerToken> tokens = this.createMergeTokens();
        this.assertTokens(tokens, expectedToDb, expectedToModel);
        this.execute(tokens);
    }

    protected MergerFactory mergerFactory() {
        return this.node.getAdapter().mergerFactory();
    }

    protected void dropTableIfPresent(String tableName) throws Exception {
        DataMap map = new DataMap("dummy");
        map.setQuotingSQLIdentifiers(map.isQuotingSQLIdentifiers());
        DbEntity entity = new DbEntity(tableName);
        map.addDbEntity(entity);
        AbstractToDbToken t = (AbstractToDbToken)this.mergerFactory().createDropTableToDb(entity);
        for (String sql : t.createSql(this.node.getAdapter())) {
            try {
                this.executeSql(sql);
            }
            catch (Exception e) {
                this.logger.info((Object)("Exception dropping table " + tableName + ", probably abscent.."));
            }
        }
    }
}

