/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class SetNotNullToDb
extends AbstractToDbToken.EntityAndColumn {
    public SetNotNullToDb(DbEntity entity, DbAttribute column) {
        super("Set Not Null", entity, column);
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        QuotingStrategy context = adapter.getQuotingStrategy();
        return Collections.singletonList("ALTER TABLE " + context.quotedFullyQualifiedName(this.getEntity()) + " ALTER COLUMN " + context.quotedName(this.getColumn()) + " SET NOT NULL");
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createSetAllowNullToModel(this.getEntity(), this.getColumn());
    }
}

