/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.ExecutingMergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.builders.ObjectMother;
import org.junit.Assert;
import org.junit.Test;

public class TokensToModelExecution {
    @Test
    public void testCreateAndDropTable() throws Exception {
        DbEntity entity = ObjectMother.dbEntity().build();
        DataMap dataMap = ObjectMother.dataMap().build();
        Assert.assertTrue((boolean)dataMap.getDbEntityMap().isEmpty());
        Assert.assertTrue((boolean)dataMap.getObjEntityMap().isEmpty());
        ExecutingMergerContext context = new ExecutingMergerContext(dataMap, new DataNode());
        this.factory().createCreateTableToModel(entity).execute(context);
        Assert.assertEquals((long)1L, (long)dataMap.getDbEntityMap().size());
        Assert.assertEquals((long)1L, (long)dataMap.getObjEntities().size());
        Assert.assertEquals((Object)entity, (Object)dataMap.getDbEntity(entity.getName()));
        this.factory().createDropTableToModel(entity).execute(context);
        Assert.assertTrue((boolean)dataMap.getDbEntityMap().isEmpty());
        Assert.assertTrue((boolean)dataMap.getObjEntityMap().isEmpty());
    }

    @Test
    public void testCreateAndDropColumn() throws Exception {
        DbAttribute attr = ObjectMother.dbAttr("attr").build();
        DbEntity entity = ObjectMother.dbEntity().build();
        DataMap dataMap = ObjectMother.dataMap().with(entity).build();
        Assert.assertEquals((long)1L, (long)dataMap.getDbEntityMap().size());
        Assert.assertTrue((boolean)dataMap.getObjEntityMap().isEmpty());
        ExecutingMergerContext context = new ExecutingMergerContext(dataMap, new DataNode());
        this.factory().createAddColumnToModel(entity, attr).execute(context);
        Assert.assertEquals((long)1L, (long)dataMap.getDbEntityMap().size());
        Assert.assertEquals((long)1L, (long)entity.getAttributes().size());
        Assert.assertEquals((Object)attr, (Object)entity.getAttribute(attr.getName()));
        this.factory().createDropColumnToModel(entity, attr).execute(context);
        Assert.assertEquals((long)1L, (long)dataMap.getDbEntityMap().size());
        Assert.assertTrue((boolean)entity.getAttributes().isEmpty());
        Assert.assertTrue((boolean)dataMap.getObjEntityMap().isEmpty());
    }

    private MergerFactory factory() {
        return new MergerFactory();
    }
}

