/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.ejbql.EJBQLCompiledExpression;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.UnitTestClosure;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.util.XMLEncoder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class EJBQLQueryIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private ServerRuntime runtime;
    @Inject
    protected DataChannelInterceptor queryInterceptor;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tArtist;
    private TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE"});
    }

    protected void createArtistsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "a0"});
        this.tArtist.insert(new Object[]{33002, "a1"});
        this.tArtist.insert(new Object[]{33003, "a2"});
        this.tArtist.insert(new Object[]{33004, "a3"});
        this.tArtist.insert(new Object[]{33005, "a4"});
    }

    protected void createPaintingsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "a0"});
        this.tArtist.insert(new Object[]{33002, "a1"});
        this.tPainting.insert(new Object[]{33001, 33001, "title0"});
        this.tPainting.insert(new Object[]{33002, 33002, "title1"});
        this.tPainting.insert(new Object[]{33003, 33002, "%%?_title%%_"});
    }

    @Test
    public void testParameters() {
        String ejbql = "select a FROM Artist a WHERE a.artistName = ?1 OR a.artistName = :name";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter(1, (Object)"X");
        query.setParameter("name", (Object)"Y");
        Map<String, Object> parameters = query.getNamedParameters();
        Map<Integer, Object> parameters1 = query.getPositionalParameters();
        Assert.assertEquals((long)1L, (long)parameters.size());
        Assert.assertEquals((long)1L, (long)parameters1.size());
        Assert.assertEquals((Object)"X", (Object)parameters1.get(new Integer(1)));
        Assert.assertEquals((Object)"Y", (Object)parameters.get("name"));
    }

    @Test
    public void testCacheParameters() {
        String ejbql1 = "select a FROM Artist a WHERE a.artistName = ?1 OR a.artistName = :name";
        EJBQLQuery q1 = new EJBQLQuery(ejbql1);
        q1.setParameter(1, (Object)"X");
        q1.setParameter("name", (Object)"Y");
        q1.setFetchOffset(1);
        q1.setFetchLimit(5);
        q1.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        String ejbql2 = "select a FROM Artist a WHERE a.artistName = ?1 OR a.artistName = :name";
        EJBQLQuery q2 = new EJBQLQuery(ejbql2);
        q2.setParameter(1, (Object)"X");
        q2.setParameter("name", (Object)"Y");
        q2.setFetchOffset(1);
        q2.setFetchLimit(5);
        q2.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        Assert.assertEquals((Object)q1.getMetaData(resolver).getCacheKey(), (Object)q2.getMetaData(resolver).getCacheKey());
    }

    @Test
    public void testCacheStrategy() throws Exception {
        this.createArtistsDataSet();
        String ejbql = "select a FROM Artist a";
        EJBQLQuery query = new EJBQLQuery("select a FROM Artist a");
        query.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        final List artist1 = this.context.performQuery(query);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                EJBQLQuery query1 = new EJBQLQuery("select a FROM Artist a");
                query1.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
                List artist2 = EJBQLQueryIT.this.context.performQuery(query1);
                Assert.assertEquals((Object)((Artist)artist1.get(0)).getArtistName(), (Object)((Artist)artist2.get(0)).getArtistName());
            }
        });
    }

    @Test
    public void testDataRows() throws Exception {
        this.createArtistsDataSet();
        String ejbql = "select a FROM Artist a";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setFetchingDataRows(true);
        List artists = this.context.performQuery(query);
        DataRow row = (DataRow)artists.get(0);
        String artistName = (String)row.get("ARTIST_NAME");
        Artist artist = (Artist)this.context.objectFromDataRow("Artist", row);
        Assert.assertEquals((Object)artistName, (Object)artist.getArtistName());
    }

    @Test
    public void testGetExpression() {
        String ejbql = "select a FROM Artist a";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        EJBQLCompiledExpression parsed = query.getExpression(this.runtime.getDataDomain().getEntityResolver());
        Assert.assertNotNull((Object)parsed);
        Assert.assertEquals((Object)ejbql, (Object)parsed.getSource());
    }

    @Test
    public void testMissingEntityBeanVariable() {
        String ejbql = "SELECT b FROM Artist a";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        try {
            this.context.performQuery(query);
            Assert.fail((String)("expected an instance of " + EJBQLException.class.getSimpleName() + " to have been thrown."));
        }
        catch (EJBQLException e) {
            Assert.assertEquals((Object)"the entity variable 'b' does not refer to any entity in the FROM clause", (Object)e.getUnlabeledMessage());
        }
        catch (Throwable th) {
            Assert.fail((String)("expected an instance of " + EJBQLException.class.getSimpleName() + " to have been thrown."));
        }
    }

    @Test
    public void testGetName() {
        String ejbql = "select a FROM Artist a";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        Assert.assertNull((Object)query.getName());
        query.setName("XYZ");
        Assert.assertEquals((Object)"XYZ", (Object)query.getName());
    }

    @Test
    public void testUniqueKeyEntity() {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        String ejbql = "select a FROM Artist a";
        EJBQLQuery q1 = new EJBQLQuery(ejbql);
        q1.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        EJBQLQuery q2 = new EJBQLQuery(ejbql);
        q2.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        Assert.assertEquals((Object)q1.getMetaData(resolver).getCacheKey(), (Object)q2.getMetaData(resolver).getCacheKey());
    }

    @Test
    public void testGetMetadata() {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        String ejbql = "select a FROM Artist a";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        QueryMetadata md = query.getMetaData(resolver);
        Assert.assertNotNull((Object)md);
        Assert.assertNotNull((Object)md.getClassDescriptor());
        Assert.assertSame((Object)resolver.getClassDescriptor("Artist"), (Object)md.getClassDescriptor());
        Assert.assertNotNull((Object)md.getObjEntity());
        Assert.assertSame((Object)resolver.getObjEntity("Artist"), (Object)md.getObjEntity());
        Assert.assertFalse((boolean)md.isFetchingDataRows());
        Assert.assertTrue((boolean)md.isRefreshingObjects());
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.NO_CACHE), (Object)((Object)md.getCacheStrategy()));
    }

    @Test
    public void testSelectRelationship() throws Exception {
        this.createPaintingsDataSet();
        String ejbql = "SELECT p.toArtist FROM Painting p";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List result = this.context.performQuery(query);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals(Artist.class, result.get(0).getClass());
        String ejbql2 = "SELECT p.toArtist, p FROM Painting p";
        EJBQLQuery query2 = new EJBQLQuery(ejbql2);
        List result2 = this.context.performQuery(query2);
        Assert.assertNotNull((Object)result2);
        Assert.assertEquals((long)3L, (long)result2.size());
        Assert.assertEquals((long)2L, (long)((Object[])result2.get(0)).length);
        Assert.assertEquals(Artist.class, ((Object[])result2.get(0))[0].getClass());
        Assert.assertEquals(Painting.class, ((Object[])result2.get(0))[1].getClass());
        String ejbql3 = "SELECT p.toArtist, p.paintingTitle FROM Painting p";
        EJBQLQuery query3 = new EJBQLQuery(ejbql3);
        List result3 = this.context.performQuery(query3);
        Assert.assertNotNull((Object)result3);
        Assert.assertEquals((long)3L, (long)result3.size());
        Assert.assertEquals((long)2L, (long)((Object[])result3.get(0)).length);
        Assert.assertEquals(Artist.class, ((Object[])result3.get(0))[0].getClass());
        Assert.assertEquals(String.class, ((Object[])result3.get(0))[1].getClass());
    }

    @Test
    public void testEncodeAsXML() {
        String ejbql = "select a FROM Artist a";
        String name = "Test";
        StringWriter w = new StringWriter();
        XMLEncoder e = new XMLEncoder(new PrintWriter(w));
        String separator = System.getProperty("line.separator");
        StringBuffer s = new StringBuffer("<query name=\"");
        s.append(name);
        s.append("\" factory=\"");
        s.append("org.apache.cayenne.map.EjbqlBuilder");
        s.append("\">");
        s.append(separator);
        EJBQLQuery query = new EJBQLQuery(ejbql);
        if (query.getEjbqlStatement() != null) {
            s.append("<ejbql><![CDATA[");
            s.append(query.getEjbqlStatement());
            s.append("]]></ejbql>");
        }
        s.append(separator);
        s.append("</query>");
        s.append(separator);
        query.setName(name);
        query.encodeAsXML(e);
        Assert.assertEquals((Object)w.getBuffer().toString(), (Object)s.toString());
    }

    @Test
    public void testInWithMultipleStringPositionalParameters_withBrackets() throws Exception {
        this.createPaintingsDataSet();
        EJBQLQuery query = new EJBQLQuery("select p from Painting p where p.paintingTitle in (?1,?2,?3)");
        query.setParameter(1, (Object)"title0");
        query.setParameter(2, (Object)"title1");
        query.setParameter(3, (Object)"title2");
        List paintings = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)paintings.size());
    }

    @Test
    public void testInWithSingleStringPositionalParameter_withoutBrackets() throws Exception {
        this.createPaintingsDataSet();
        EJBQLQuery query = new EJBQLQuery("select p from Painting p where p.paintingTitle in ?1");
        query.setParameter(1, (Object)"title0");
        List paintings = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)paintings.size());
    }

    @Test
    public void testInWithSingleCollectionNamedParameter_withoutBrackets() throws Exception {
        this.createPaintingsDataSet();
        EJBQLQuery query = new EJBQLQuery("select p from Painting p where p.toArtist in :artists");
        query.setParameter("artists", (Object)this.context.performQuery(new SelectQuery<Artist>(Artist.class)));
        List paintings = this.context.performQuery(query);
        Assert.assertEquals((long)3L, (long)paintings.size());
    }

    @Test
    public void testInWithSingleCollectionPositionalParameter_withoutBrackets() throws Exception {
        this.createPaintingsDataSet();
        EJBQLQuery query = new EJBQLQuery("select p from Painting p where p.toArtist in ?1");
        query.setParameter(1, (Object)this.context.performQuery(new SelectQuery<Artist>(Artist.class)));
        List paintings = this.context.performQuery(query);
        Assert.assertEquals((long)3L, (long)paintings.size());
    }

    @Test
    public void testInWithSingleCollectionNamedParameter_withBrackets() throws Exception {
        this.createPaintingsDataSet();
        EJBQLQuery query = new EJBQLQuery("select p from Painting p where p.toArtist in (:artists)");
        query.setParameter("artists", (Object)this.context.performQuery(new SelectQuery<Artist>(Artist.class)));
        List paintings = this.context.performQuery(query);
        Assert.assertEquals((long)3L, (long)paintings.size());
    }

    @Test
    public void testInWithSingleCollectionPositionalParameter_withBrackets() throws Exception {
        this.createPaintingsDataSet();
        EJBQLQuery query = new EJBQLQuery("select p from Painting p where p.toArtist in (?1)");
        query.setParameter(1, (Object)this.context.performQuery(new SelectQuery<Artist>(Artist.class)));
        List paintings = this.context.performQuery(query);
        Assert.assertEquals((long)3L, (long)paintings.size());
    }

    @Test
    public void testNullParameter() {
        EJBQLQuery query = new EJBQLQuery("select p from Painting p WHERE p.toArtist=:x");
        query.setParameter("x", null);
        this.context.performQuery(query);
    }

    @Test
    public void testNullNotEqualsParameter() {
        EJBQLQuery query = new EJBQLQuery("select p from Painting p WHERE p.toArtist<>:x");
        query.setParameter("x", null);
        this.context.performQuery(query);
    }

    @Test
    public void testNullPositionalParameter() {
        EJBQLQuery query = new EJBQLQuery("select p from Painting p WHERE p.toArtist=?1");
        query.setParameter(1, null);
        this.context.performQuery(query);
    }

    @Test
    public void testNullAndNotNullParameter() {
        EJBQLQuery query = new EJBQLQuery("select p from Painting p WHERE p.toArtist=:x OR p.toArtist.artistName=:b");
        query.setParameter("x", null);
        query.setParameter("b", (Object)"Y");
        this.context.performQuery(query);
    }

    @Test
    public void testLikeWithExplicitEscape() throws Exception {
        this.createPaintingsDataSet();
        EJBQLQuery query = new EJBQLQuery("SELECT p FROM Painting p WHERE p.paintingTitle LIKE '|%|%?|_title|%|%|_' ESCAPE '|'");
        List paintings = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)paintings.size());
        Assert.assertEquals((Object)"%%?_title%%_", (Object)((Painting)paintings.get(0)).getPaintingTitle());
    }

    @Test
    public void testJoinToJoined() {
        EJBQLQuery query = new EJBQLQuery("select g from Gallery g inner join g.paintingArray p where p.toArtist.artistName like '%a%'");
        this.context.performQuery(query);
    }

    @Test
    public void testJoinAndCount() {
        EJBQLQuery query = new EJBQLQuery("select count(p) from Painting p where p.toGallery.galleryName LIKE '%a%' AND (p.paintingTitle like '%a%' or p.toArtist.artistName like '%a%')");
        this.context.performQuery(query);
    }

    @Test
    public void testRelationshipWhereClause() throws Exception {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("a");
        Painting p = this.context.newObject(Painting.class);
        p.setPaintingTitle("p");
        p.setToArtist(a);
        this.context.commitChanges();
        EJBQLQuery query = new EJBQLQuery("select p from Painting p where p.toArtist=:a");
        query.setParameter("a", (Object)a);
        List paintings = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)paintings.size());
        Assert.assertSame((Object)p, paintings.get(0));
    }

    @Test
    public void testRelationshipWhereClause2() throws Exception {
        Expression exp = ExpressionFactory.matchExp("toGallery", null);
        EJBQLQuery query = new EJBQLQuery("select p.toArtist from Painting p where " + exp.toEJBQL("p"));
        this.context.performQuery(query);
    }

    @Test
    public void testOrBrackets() throws Exception {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("testOrBrackets");
        this.context.commitChanges();
        EJBQLQuery query = new EJBQLQuery("select a from Artist a where a.artistName <> a.artistName and (a.artistName <> a.artistName or a.artistName = a.artistName)");
        Assert.assertEquals((long)this.context.performQuery(query).size(), (long)0L);
        query = new EJBQLQuery("select a from Artist a where a.artistName <> a.artistName and a.artistName <> a.artistName or a.artistName = a.artistName");
        Assert.assertTrue((this.context.performQuery(query).size() > 0 ? 1 : 0) != 0);
        query = new EJBQLQuery("select a from Artist a where not(a.artistName <> a.artistName and a.artistName <> a.artistName or a.artistName = a.artistName)");
        Assert.assertEquals((long)this.context.performQuery(query).size(), (long)0L);
        query = new EJBQLQuery("select a from Artist a where not a.artistName <> a.artistName or a.artistName = a.artistName");
        Assert.assertTrue((this.context.performQuery(query).size() > 0 ? 1 : 0) != 0);
    }
}

