/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ObjectSelect_CompileIT
extends ServerCase {
    @Inject
    private EntityResolver resolver;

    @Test
    public void testCreateReplacementQuery_Bare() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        Query replacement = q.createReplacementQuery(this.resolver);
        Assert.assertThat((Object)replacement, (Matcher)CoreMatchers.instanceOf(SelectQuery.class));
        SelectQuery selectQuery = (SelectQuery)replacement;
        Assert.assertNull((Object)selectQuery.getQualifier());
        Assert.assertEquals(Artist.class, (Object)selectQuery.getRoot());
        Assert.assertEquals((long)0L, (long)selectQuery.getOrderings().size());
        Assert.assertNull((Object)selectQuery.getPrefetchTree());
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.NO_CACHE), (Object)((Object)selectQuery.getCacheStrategy()));
        Assert.assertNull((Object)selectQuery.getCacheGroups());
        Assert.assertEquals((long)0L, (long)selectQuery.getFetchLimit());
        Assert.assertEquals((long)0L, (long)selectQuery.getFetchOffset());
        Assert.assertEquals((long)0L, (long)selectQuery.getPageSize());
        Assert.assertEquals((long)0L, (long)selectQuery.getStatementFetchSize());
    }

    @Test
    public void testCreateReplacementQuery_Full() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("me")).orderBy(Artist.DATE_OF_BIRTH.asc(), Artist.ARTIST_NAME.desc()).prefetch(Artist.PAINTING_ARRAY.joint()).localCache("cg2", "cg1").limit(46).offset(9).pageSize(6).statementFetchSize(789);
        Query replacement = q.createReplacementQuery(this.resolver);
        Assert.assertThat((Object)replacement, (Matcher)CoreMatchers.instanceOf(SelectQuery.class));
        SelectQuery selectQuery = (SelectQuery)replacement;
        Assert.assertEquals((Object)"artistName = \"me\"", (Object)selectQuery.getQualifier().toString());
        Assert.assertEquals((long)2L, (long)selectQuery.getOrderings().size());
        Assert.assertArrayEquals((Object[])new Object[]{Artist.DATE_OF_BIRTH.asc(), Artist.ARTIST_NAME.desc()}, (Object[])selectQuery.getOrderings().toArray());
        PrefetchTreeNode prefetch = selectQuery.getPrefetchTree();
        Assert.assertNotNull((Object)prefetch);
        Assert.assertEquals((long)1L, (long)prefetch.getChildren().size());
        PrefetchTreeNode childPrefetch = prefetch.getNode(Artist.PAINTING_ARRAY.getName());
        Assert.assertEquals((Object)Artist.PAINTING_ARRAY.getName(), (Object)childPrefetch.getName());
        Assert.assertEquals((long)1L, (long)childPrefetch.getSemantics());
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.LOCAL_CACHE), (Object)((Object)selectQuery.getCacheStrategy()));
        Assert.assertArrayEquals((Object[])new Object[]{"cg2", "cg1"}, (Object[])selectQuery.getCacheGroups());
        Assert.assertEquals((long)46L, (long)selectQuery.getFetchLimit());
        Assert.assertEquals((long)9L, (long)selectQuery.getFetchOffset());
        Assert.assertEquals((long)6L, (long)selectQuery.getPageSize());
        Assert.assertEquals((long)789L, (long)selectQuery.getStatementFetchSize());
    }

    @Test
    public void testCreateReplacementQuery_RootClass() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        SelectQuery qr = (SelectQuery)q.createReplacementQuery(this.resolver);
        Assert.assertEquals(Artist.class, (Object)qr.getRoot());
        Assert.assertFalse((boolean)qr.isFetchingDataRows());
    }

    @Test
    public void testCreateReplacementQuery_RootDataRow() {
        ObjectSelect<DataRow> q = ObjectSelect.dataRowQuery(Artist.class);
        SelectQuery qr = (SelectQuery)q.createReplacementQuery(this.resolver);
        Assert.assertEquals(Artist.class, (Object)qr.getRoot());
        Assert.assertTrue((boolean)qr.isFetchingDataRows());
    }

    @Test
    public void testCreateReplacementQuery_RootDbEntity() {
        ObjectSelect<DataRow> q = ObjectSelect.dbQuery("ARTIST");
        SelectQuery qr = (SelectQuery)q.createReplacementQuery(this.resolver);
        Assert.assertEquals((Object)this.resolver.getDbEntity("ARTIST"), (Object)qr.getRoot());
        Assert.assertTrue((boolean)qr.isFetchingDataRows());
    }

    @Test
    public void testCreateReplacementQuery_RootObjEntity() {
        ObjectSelect<CayenneDataObject> q = ObjectSelect.query(CayenneDataObject.class, "Artist");
        SelectQuery qr = (SelectQuery)q.createReplacementQuery(this.resolver);
        Assert.assertEquals((Object)this.resolver.getObjEntity(Artist.class), (Object)qr.getRoot());
        Assert.assertFalse((boolean)qr.isFetchingDataRows());
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testCreateReplacementQuery_RootAbscent() {
        ObjectSelect<DataRow> q = ObjectSelect.dataRowQuery(Artist.class).entityName(null);
        q.createReplacementQuery(this.resolver);
    }

    @Test
    public void testCreateReplacementQuery_DataRows() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        SelectQuery selectQuery1 = (SelectQuery)q.createReplacementQuery(this.resolver);
        Assert.assertFalse((boolean)selectQuery1.isFetchingDataRows());
        q.fetchDataRows();
        SelectQuery selectQuery2 = (SelectQuery)q.createReplacementQuery(this.resolver);
        Assert.assertTrue((boolean)selectQuery2.isFetchingDataRows());
    }
}

