/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class PrefetchTreeNodeTest {
    @Test
    public void testAddPath() {
        PrefetchTreeNode tree = new PrefetchTreeNode();
        tree.addPath("abc");
        tree.addPath("abc.def.mnk");
        tree.addPath("xyz");
        Assert.assertTrue((boolean)tree.isPhantom());
        PrefetchTreeNode n1 = tree.getNode("abc");
        Assert.assertNotNull((Object)n1);
        Assert.assertTrue((boolean)n1.isPhantom());
        Assert.assertEquals((Object)"abc", (Object)n1.getName());
        PrefetchTreeNode n2 = tree.getNode("abc.def");
        Assert.assertNotNull((Object)n2);
        Assert.assertTrue((boolean)n2.isPhantom());
        Assert.assertEquals((Object)"def", (Object)n2.getName());
        PrefetchTreeNode n3 = tree.getNode("abc.def.mnk");
        Assert.assertNotNull((Object)n3);
        Assert.assertTrue((boolean)n3.isPhantom());
        Assert.assertEquals((Object)"mnk", (Object)n3.getName());
        PrefetchTreeNode n4 = tree.getNode("xyz");
        Assert.assertNotNull((Object)n4);
        Assert.assertTrue((boolean)n4.isPhantom());
        Assert.assertEquals((Object)"xyz", (Object)n4.getName());
    }

    @Test
    public void testGetPath() {
        PrefetchTreeNode tree = new PrefetchTreeNode();
        tree.addPath("abc");
        tree.addPath("abc.def.mnk");
        tree.addPath("xyz");
        Assert.assertEquals((Object)"", (Object)tree.getPath());
        PrefetchTreeNode n1 = tree.getNode("abc");
        Assert.assertEquals((Object)"abc", (Object)n1.getPath());
        PrefetchTreeNode n2 = tree.getNode("abc.def");
        Assert.assertEquals((Object)"abc.def", (Object)n2.getPath());
        PrefetchTreeNode n3 = tree.getNode("abc.def.mnk");
        Assert.assertEquals((Object)"abc.def.mnk", (Object)n3.getPath());
        PrefetchTreeNode n4 = tree.getNode("xyz");
        Assert.assertEquals((Object)"xyz", (Object)n4.getPath());
    }

    @Test
    public void testTreeSerialization() throws Exception {
        PrefetchTreeNode n1 = new PrefetchTreeNode();
        PrefetchTreeNode n2 = n1.addPath("abc");
        PrefetchTreeNode nc1 = Util.cloneViaSerialization(n1);
        Assert.assertNotNull((Object)nc1);
        PrefetchTreeNode nc2 = nc1.getNode("abc");
        Assert.assertNotNull((Object)nc2);
        Assert.assertNotSame((Object)nc2, (Object)n2);
        Assert.assertSame((Object)nc1, (Object)nc2.getParent());
        Assert.assertEquals((Object)"abc", (Object)nc2.getName());
    }

    @Test
    public void testSubtreeSerialization() throws Exception {
        PrefetchTreeNode n1 = new PrefetchTreeNode();
        PrefetchTreeNode n2 = n1.addPath("abc");
        PrefetchTreeNode n3 = n2.addPath("xyz");
        PrefetchTreeNode nc2 = Util.cloneViaSerialization(n2);
        Assert.assertNotNull((Object)nc2);
        Assert.assertNull((Object)nc2.getParent());
        PrefetchTreeNode nc3 = nc2.getNode("xyz");
        Assert.assertNotNull((Object)nc3);
        Assert.assertNotSame((Object)nc3, (Object)n3);
        Assert.assertSame((Object)nc2, (Object)nc3.getParent());
        Assert.assertEquals((Object)"xyz", (Object)nc3.getName());
    }

    @Test
    public void testCloneJointSubtree() throws Exception {
        PrefetchTreeNode root = new PrefetchTreeNode(null, "root");
        root.setPhantom(false);
        PrefetchTreeNode joint1 = root.addPath("joint1");
        joint1.setPhantom(false);
        joint1.setSemantics(1);
        PrefetchTreeNode joint2 = root.addPath("joint2");
        joint2.setPhantom(false);
        joint2.setSemantics(1);
        PrefetchTreeNode disjoint = joint1.addPath("disjoint1");
        disjoint.setPhantom(false);
        disjoint.setSemantics(2);
        PrefetchTreeNode cloned = root.cloneJointSubtree();
        Assert.assertEquals((Object)"root", (Object)cloned.getName());
        Assert.assertEquals((long)2L, (long)cloned.getChildren().size());
        PrefetchTreeNode joint1Clone = cloned.getChild("joint1");
        Assert.assertNotNull((Object)joint1Clone);
        Assert.assertEquals((Object)"joint1", (Object)joint1.getPath());
        Assert.assertEquals((long)0L, (long)joint1Clone.getChildren().size());
        PrefetchTreeNode joint2Clone = cloned.getChild("joint2");
        Assert.assertNotNull((Object)joint2Clone);
        Assert.assertEquals((Object)"joint2", (Object)joint2.getPath());
        Assert.assertEquals((long)0L, (long)joint2Clone.getChildren().size());
    }
}

