/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ProcedureQueryCacheKeyIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testNoCache() {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        ProcedureQuery query = new ProcedureQuery("ABC", Artist.class);
        QueryMetadata md1 = query.getMetaData(resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.NO_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNull((Object)md1.getCacheKey());
        query.setName("XYZ");
        QueryMetadata md2 = query.getMetaData(resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.NO_CACHE), (Object)((Object)md2.getCacheStrategy()));
        Assert.assertNull((Object)md2.getCacheKey());
    }

    @Test
    public void testLocalCache() {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        ProcedureQuery query = new ProcedureQuery("ABC", Artist.class);
        query.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        QueryMetadata md1 = query.getMetaData(resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.LOCAL_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNotNull((Object)md1.getCacheKey());
    }

    @Test
    public void testSharedCache() {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        ProcedureQuery query = new ProcedureQuery("ABC", Artist.class);
        query.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        QueryMetadata md1 = query.getMetaData(resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNotNull((Object)md1.getCacheKey());
    }

    @Test
    public void testNamedQuery() {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        ProcedureQuery query = new ProcedureQuery("ABC", Artist.class);
        query.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        query.setName("XYZ");
        QueryMetadata md1 = query.getMetaData(resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertEquals((Object)"proc:", (Object)md1.getCacheKey());
    }

    @Test
    public void testCacheFetchOffsetAndLimit() {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        ProcedureQuery q1 = new ProcedureQuery("ABC", Artist.class);
        q1.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        q1.setFetchOffset(5);
        q1.setFetchLimit(3);
        ProcedureQuery q2 = new ProcedureQuery("ABC", Artist.class);
        q2.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        q2.setFetchOffset(5);
        q2.setFetchLimit(3);
        Assert.assertEquals((Object)q1.getMetaData(resolver).getCacheKey(), (Object)q2.getMetaData(resolver).getCacheKey());
    }
}

