/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.SelectById;
import org.apache.cayenne.testdo.testmap.Artist;
import org.junit.Assert;
import org.junit.Test;

public class SelectByIdTest {
    @Test
    public void testPrefetch() {
        PrefetchTreeNode root = PrefetchTreeNode.withPath("a.b", 1);
        SelectById<Artist> q = SelectById.query(Artist.class, 6);
        q.prefetch(root);
        Assert.assertSame((Object)root, (Object)q.getPrefetches());
    }

    @Test
    public void testPrefetch_Path() {
        SelectById<Artist> q = SelectById.query(Artist.class, 7);
        q.prefetch("a.b", 2);
        PrefetchTreeNode root1 = q.getPrefetches();
        Assert.assertNotNull((Object)root1);
        Assert.assertNotNull((Object)root1.getNode("a.b"));
        q.prefetch("a.c", 2);
        PrefetchTreeNode root2 = q.getPrefetches();
        Assert.assertNotNull((Object)root2);
        Assert.assertNotNull((Object)root2.getNode("a.c"));
        Assert.assertNull((Object)root2.getNode("a.b"));
        Assert.assertNotSame((Object)root1, (Object)root2);
    }

    @Test
    public void testAddPrefetch() {
        PrefetchTreeNode root = PrefetchTreeNode.withPath("a.b", 1);
        SelectById<Artist> q = SelectById.query(Artist.class, 8);
        q.prefetch(root);
        Assert.assertSame((Object)root, (Object)q.getPrefetches());
        PrefetchTreeNode subRoot = PrefetchTreeNode.withPath("a.b.c", 1);
        q.addPrefetch(subRoot);
        Assert.assertSame((Object)root, (Object)q.getPrefetches());
        Assert.assertNotNull((Object)root.getNode("a.b.c"));
    }
}

