/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class SelectQueryCacheKeyIT
extends ServerCase {
    @Inject
    private EntityResolver resolver;

    @Test
    public void testNoCache() {
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        QueryMetadata md1 = query.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.NO_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNull((Object)md1.getCacheKey());
        query.setName("XYZ");
        QueryMetadata md2 = query.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.NO_CACHE), (Object)((Object)md2.getCacheStrategy()));
        Assert.assertNull((Object)md2.getCacheKey());
    }

    @Test
    public void testLocalCache() {
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        QueryMetadata md1 = query.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.LOCAL_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNotNull((Object)md1.getCacheKey());
    }

    @Test
    public void testUseLocalCache() {
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class);
        q1.useLocalCache(new String[0]);
        QueryMetadata md1 = q1.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.LOCAL_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNotNull((Object)md1.getCacheKey());
        Assert.assertEquals((long)0L, (long)md1.getCacheGroups().length);
        SelectQuery<Artist> q2 = new SelectQuery<Artist>(Artist.class);
        q2.useLocalCache("g1", "g2");
        QueryMetadata md2 = q2.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.LOCAL_CACHE), (Object)((Object)md2.getCacheStrategy()));
        Assert.assertNotNull((Object)md2.getCacheKey());
        Assert.assertEquals((long)2L, (long)md2.getCacheGroups().length);
    }

    @Test
    public void testSharedCache() {
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        QueryMetadata md1 = query.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNotNull((Object)md1.getCacheKey());
    }

    @Test
    public void testUseSharedCache() {
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class);
        q1.useSharedCache(new String[0]);
        QueryMetadata md1 = q1.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNotNull((Object)md1.getCacheKey());
        Assert.assertEquals((long)0L, (long)md1.getCacheGroups().length);
        SelectQuery<Artist> q2 = new SelectQuery<Artist>(Artist.class);
        q2.useSharedCache("g1", "g2");
        QueryMetadata md2 = q2.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)md2.getCacheStrategy()));
        Assert.assertNotNull((Object)md2.getCacheKey());
        Assert.assertEquals((long)2L, (long)md2.getCacheGroups().length);
    }

    @Test
    public void testNamedQuery() {
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        query.setName("XYZ");
        QueryMetadata md1 = query.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertFalse((boolean)"XYZ".equals(md1.getCacheKey()));
    }

    @Test
    public void testUniqueKeyEntity() {
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class);
        q1.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        SelectQuery<Artist> q2 = new SelectQuery<Artist>(Artist.class);
        q2.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        SelectQuery<Painting> q3 = new SelectQuery<Painting>(Painting.class);
        q3.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        Assert.assertNotNull((Object)q1.getMetaData(this.resolver).getCacheKey());
        Assert.assertEquals((Object)q1.getMetaData(this.resolver).getCacheKey(), (Object)q2.getMetaData(this.resolver).getCacheKey());
        Assert.assertFalse((boolean)q1.getMetaData(this.resolver).getCacheKey().equals(q3.getMetaData(this.resolver).getCacheKey()));
    }

    @Test
    public void testUniqueKeyEntityQualifier() {
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class);
        q1.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        q1.setQualifier(ExpressionFactory.matchExp("a", "b"));
        SelectQuery<Artist> q2 = new SelectQuery<Artist>(Artist.class);
        q2.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        q2.setQualifier(ExpressionFactory.matchExp("a", "b"));
        SelectQuery<Artist> q3 = new SelectQuery<Artist>(Artist.class);
        q3.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        q3.setQualifier(ExpressionFactory.matchExp("a", "c"));
        Assert.assertNotNull((Object)q1.getMetaData(this.resolver).getCacheKey());
        Assert.assertEquals((Object)q1.getMetaData(this.resolver).getCacheKey(), (Object)q2.getMetaData(this.resolver).getCacheKey());
        Assert.assertFalse((boolean)q1.getMetaData(this.resolver).getCacheKey().equals(q3.getMetaData(this.resolver).getCacheKey()));
    }

    @Test
    public void testUniqueKeyEntityFetchLimit() {
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class);
        q1.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        q1.setFetchLimit(5);
        SelectQuery<Artist> q2 = new SelectQuery<Artist>(Artist.class);
        q2.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        q2.setFetchLimit(5);
        SelectQuery<Artist> q3 = new SelectQuery<Artist>(Artist.class);
        q3.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        q3.setFetchLimit(6);
        SelectQuery<Artist> q4 = new SelectQuery<Artist>(Artist.class);
        q4.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        Assert.assertNotNull((Object)q1.getMetaData(this.resolver).getCacheKey());
        Assert.assertEquals((Object)q1.getMetaData(this.resolver).getCacheKey(), (Object)q2.getMetaData(this.resolver).getCacheKey());
        Assert.assertFalse((boolean)q1.getMetaData(this.resolver).getCacheKey().equals(q3.getMetaData(this.resolver).getCacheKey()));
        Assert.assertFalse((boolean)q1.getMetaData(this.resolver).getCacheKey().equals(q4.getMetaData(this.resolver).getCacheKey()));
    }
}

