/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.resource;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.ResourceLocator;
import org.apache.cayenne.resource.URLResource;

public class FilesystemResourceLocator
implements ResourceLocator {
    protected File[] roots;

    public FilesystemResourceLocator(File ... roots) {
        this.init(roots);
    }

    public FilesystemResourceLocator(Collection<File> roots) {
        if (roots == null) {
            throw new NullPointerException("Null roots");
        }
        this.init(roots.toArray(new File[roots.size()]));
    }

    private void init(File[] roots) {
        if (roots == null || roots.length == 0) {
            roots = new File[]{new File(System.getProperty("user.dir"))};
        }
        this.roots = new File[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            File root;
            File file = root = roots[i].isDirectory() ? roots[i] : roots[i].getParentFile();
            if (root == null) {
                throw new ConfigurationException("Invalid root: %s", roots[i]);
            }
            this.roots[i] = root;
        }
    }

    @Override
    public Collection<Resource> findResources(String name) {
        ArrayList<Resource> resources = new ArrayList<Resource>(3);
        for (File root : this.roots) {
            File resourceFile = new File(root, name);
            if (!resourceFile.exists()) continue;
            try {
                resources.add(new URLResource(resourceFile.toURL()));
            }
            catch (MalformedURLException e) {
                throw new CayenneRuntimeException("Can't convert file to URL: %s", (Throwable)e, resourceFile.getAbsolutePath());
            }
        }
        return resources;
    }
}

