/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.resource.FilesystemResourceLocator;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.test.file.FileUtil;
import org.junit.Assert;
import org.junit.Test;

public class FilesystemResourceLocatorTest {
    @Test
    public void testArrayConstructor() {
        FilesystemResourceLocator l1 = new FilesystemResourceLocator(new File[0]);
        Assert.assertEquals((long)1L, (long)l1.roots.length);
        Assert.assertEquals((Object)System.getProperty("user.dir"), (Object)l1.roots[0].getPath());
        File base = FileUtil.baseTestDirectory();
        File f1 = new File(base, "f1");
        File f2 = new File(new File(base, "f2"), "f3");
        FilesystemResourceLocator l2 = new FilesystemResourceLocator(f1, f2);
        Assert.assertEquals((long)2L, (long)l2.roots.length);
        Assert.assertEquals((Object)base, (Object)l2.roots[0]);
        Assert.assertEquals((Object)new File(base, "f2"), (Object)l2.roots[1]);
    }

    @Test
    public void testCollectionConstructor() {
        FilesystemResourceLocator l1 = new FilesystemResourceLocator(Collections.<File>emptyList());
        Assert.assertEquals((long)1L, (long)l1.roots.length);
        Assert.assertEquals((Object)System.getProperty("user.dir"), (Object)l1.roots[0].getPath());
        File base = FileUtil.baseTestDirectory();
        File f1 = new File(base, "f1");
        File f2 = new File(new File(base, "f2"), "f3");
        FilesystemResourceLocator l2 = new FilesystemResourceLocator(Arrays.asList(f1, f2));
        Assert.assertEquals((long)2L, (long)l2.roots.length);
        Assert.assertEquals((Object)base, (Object)l2.roots[0]);
        Assert.assertEquals((Object)new File(base, "f2"), (Object)l2.roots[1]);
    }

    @Test
    public void testFindResources() throws Exception {
        File base = new File(FileUtil.baseTestDirectory(), this.getClass().getName());
        File root1 = new File(base, "r1");
        File root2 = new File(base, "r2");
        root1.mkdirs();
        root2.mkdirs();
        FilesystemResourceLocator locator = new FilesystemResourceLocator(root1, root2);
        Collection<Resource> resources1 = locator.findResources("x.txt");
        Assert.assertNotNull(resources1);
        Assert.assertEquals((long)0L, (long)resources1.size());
        File f1 = new File(root1, "x.txt");
        this.touch(f1);
        Collection<Resource> resources2 = locator.findResources("x.txt");
        Assert.assertNotNull(resources2);
        Assert.assertEquals((long)1L, (long)resources2.size());
        Assert.assertEquals((Object)f1.toURL(), (Object)resources2.iterator().next().getURL());
        File f2 = new File(root2, "x.txt");
        this.touch(f2);
        Collection<Resource> resources3 = locator.findResources("x.txt");
        Assert.assertNotNull(resources3);
        Assert.assertEquals((long)2L, (long)resources3.size());
        Resource[] resources3a = resources3.toArray(new Resource[2]);
        Assert.assertEquals((Object)f1.toURL(), (Object)resources3a[0].getURL());
        Assert.assertEquals((Object)f2.toURL(), (Object)resources3a[1].getURL());
    }

    private void touch(File f) throws Exception {
        FileOutputStream out = new FileOutputStream(f);
        out.write(97);
        out.close();
    }
}

