/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.di.server;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.util.Util;

public class UnitDbAdapterProvider
implements Provider<UnitDbAdapter> {
    static final String TEST_ADAPTERS_MAP = "org.apache.cayenne.unit.di.server.CayenneResourcesAccessStackAdapterProvider.adapters";
    private Injector injector;
    private DbAdapter adapter;
    private DataSourceInfo dataSourceInfo;
    private Map<String, String> adapterTypesMap;

    public UnitDbAdapterProvider(@Inject(value="org.apache.cayenne.unit.di.server.CayenneResourcesAccessStackAdapterProvider.adapters") Map<String, String> adapterTypesMap, @Inject DataSourceInfo dataSourceInfo, @Inject DbAdapter adapter, @Inject Injector injector) {
        this.dataSourceInfo = dataSourceInfo;
        this.adapterTypesMap = adapterTypesMap;
        this.adapter = adapter;
        this.injector = injector;
    }

    public UnitDbAdapter get() throws ConfigurationException {
        Class<?> type;
        String testAdapterType = this.adapterTypesMap.get(this.dataSourceInfo.getAdapterClassName());
        if (testAdapterType == null) {
            throw new IllegalStateException("Unmapped adapter type: " + this.dataSourceInfo.getAdapterClassName());
        }
        try {
            type = Util.getJavaClass(testAdapterType);
        }
        catch (ClassNotFoundException e) {
            throw new CayenneRuntimeException("Invalid class %s of type AccessStackAdapter", (Throwable)e, testAdapterType);
        }
        if (!UnitDbAdapter.class.isAssignableFrom(type)) {
            throw new CayenneRuntimeException("Class %s is not assignable to AccessStackAdapter", testAdapterType);
        }
        try {
            Constructor<?> c = type.getConstructor(DbAdapter.class);
            UnitDbAdapter unitAdapter = (UnitDbAdapter)c.newInstance(this.adapter);
            this.injector.injectMembers((Object)unitAdapter);
            return unitAdapter;
        }
        catch (Exception e) {
            throw new ConfigurationException("Error instantiating " + testAdapterType, (Throwable)e, new Object[0]);
        }
    }
}

