/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.Arrays;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.merge.MergeCase;
import org.apache.cayenne.util.EntityMergeSupport;
import org.junit.Assert;
import org.junit.Test;

public class EntityMergeSupportIT
extends MergeCase {
    @Test
    public void testMerging() {
        DbEntity dbEntity1 = new DbEntity("NEW_TABLE");
        DbAttribute e1col1 = new DbAttribute("ID", 4, dbEntity1);
        e1col1.setMandatory(true);
        e1col1.setPrimaryKey(true);
        dbEntity1.addAttribute(e1col1);
        DbAttribute e1col2 = new DbAttribute("NAME", 12, dbEntity1);
        e1col2.setMaxLength(10);
        e1col2.setMandatory(false);
        dbEntity1.addAttribute(e1col2);
        this.map.addDbEntity(dbEntity1);
        DbEntity dbEntity2 = new DbEntity("NEW_TABLE2");
        DbAttribute e2col1 = new DbAttribute("ID", 4, dbEntity2);
        e2col1.setMandatory(true);
        e2col1.setPrimaryKey(true);
        dbEntity2.addAttribute(e2col1);
        DbAttribute e2col2 = new DbAttribute("FK", 4, dbEntity2);
        dbEntity2.addAttribute(e2col2);
        this.map.addDbEntity(dbEntity2);
        DbRelationship rel1To2 = new DbRelationship("rel1To2");
        rel1To2.setSourceEntity(dbEntity1);
        rel1To2.setTargetEntityName(dbEntity2);
        rel1To2.setToMany(true);
        rel1To2.addJoin(new DbJoin(rel1To2, e1col1.getName(), e2col2.getName()));
        dbEntity1.addRelationship(rel1To2);
        DbRelationship rel2To1 = new DbRelationship("rel2To1");
        rel2To1.setSourceEntity(dbEntity2);
        rel2To1.setTargetEntityName(dbEntity1);
        rel2To1.setToMany(false);
        rel2To1.addJoin(new DbJoin(rel2To1, e2col2.getName(), e1col1.getName()));
        dbEntity2.addRelationship(rel2To1);
        Assert.assertSame((Object)rel1To2, (Object)rel2To1.getReverseRelationship());
        Assert.assertSame((Object)rel2To1, (Object)rel1To2.getReverseRelationship());
        ObjEntity objEntity1 = new ObjEntity("NewTable");
        objEntity1.setDbEntity(dbEntity1);
        this.map.addObjEntity(objEntity1);
        ObjEntity objEntity2 = new ObjEntity("NewTable2");
        objEntity2.setDbEntity(dbEntity2);
        this.map.addObjEntity(objEntity2);
        Assert.assertTrue((boolean)new EntityMergeSupport(this.map).synchronizeWithDbEntities(Arrays.asList(objEntity1, objEntity2)));
        Assert.assertNotNull((Object)objEntity1.getAttribute("name"));
        Assert.assertNotNull((Object)objEntity1.getRelationship("rel1To2"));
        Assert.assertNotNull((Object)objEntity2.getRelationship("rel2To1"));
        Assert.assertEquals((long)objEntity1.getRelationship("rel1To2").getDeleteRule(), (long)3L);
        Assert.assertEquals((long)objEntity2.getRelationship("rel2To1").getDeleteRule(), (long)1L);
        this.map.removeObjEntity(objEntity2.getName());
        this.map.removeObjEntity(objEntity1.getName());
        this.map.removeDbEntity(dbEntity2.getName());
        this.map.removeDbEntity(dbEntity1.getName());
    }
}

