/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cayenne.util.IndexPropertyList;
import org.apache.cayenne.util.IndexedObject;
import org.junit.Assert;
import org.junit.Test;

public class IndexPropertyListTest {
    @Test
    public void testSort() {
        IndexedObject o1 = new IndexedObject(1);
        IndexedObject o2 = new IndexedObject(2);
        IndexedObject o3 = new IndexedObject(3);
        IndexedObject o4 = new IndexedObject(4);
        List<IndexedObject> list1 = Arrays.asList(o2, o4, o3, o1);
        IndexPropertyList indexedList = new IndexPropertyList("order", list1, true);
        Assert.assertEquals((Object)o1, (Object)indexedList.get(0));
        Assert.assertEquals((Object)o2, (Object)indexedList.get(1));
        Assert.assertEquals((Object)o3, (Object)indexedList.get(2));
        Assert.assertEquals((Object)o4, (Object)indexedList.get(3));
        List<IndexedObject> list2 = Arrays.asList(o2, o4, o3, o1);
        IndexPropertyList indexedUnsortedList = new IndexPropertyList("order", list2, false);
        Assert.assertEquals((Object)o2, (Object)indexedUnsortedList.get(0));
        Assert.assertEquals((Object)o4, (Object)indexedUnsortedList.get(1));
        Assert.assertEquals((Object)o3, (Object)indexedUnsortedList.get(2));
        Assert.assertEquals((Object)o1, (Object)indexedUnsortedList.get(3));
    }

    @Test
    public void testAppend() {
        IndexedObject o1 = new IndexedObject(1);
        IndexedObject o2 = new IndexedObject(2);
        IndexedObject o3 = new IndexedObject(3);
        IndexedObject o4 = new IndexedObject(4);
        ArrayList<IndexedObject> list1 = new ArrayList<IndexedObject>(Arrays.asList(o2, o4, o3, o1));
        IndexPropertyList indexedList = new IndexPropertyList("order", list1, true);
        IndexedObject o5 = new IndexedObject(-1);
        indexedList.add(o5);
        Assert.assertEquals((long)4L, (long)o4.getOrder());
        Assert.assertTrue((o4.getOrder() < o5.getOrder() ? 1 : 0) != 0);
    }

    @Test
    public void testInsert() {
        IndexedObject o1 = new IndexedObject(1);
        IndexedObject o2 = new IndexedObject(2);
        IndexedObject o3 = new IndexedObject(3);
        IndexedObject o4 = new IndexedObject(4);
        ArrayList<IndexedObject> list1 = new ArrayList<IndexedObject>(Arrays.asList(o2, o4, o3, o1));
        IndexPropertyList indexedList = new IndexPropertyList("order", list1, true);
        IndexedObject o5 = new IndexedObject(-1);
        indexedList.add(1, o5);
        Assert.assertEquals((long)1L, (long)o1.getOrder());
        Assert.assertTrue((o1.getOrder() < o5.getOrder() ? 1 : 0) != 0);
        Assert.assertTrue((o5.getOrder() < o2.getOrder() ? 1 : 0) != 0);
        Assert.assertTrue((o2.getOrder() < o3.getOrder() ? 1 : 0) != 0);
        Assert.assertTrue((o3.getOrder() < o4.getOrder() ? 1 : 0) != 0);
    }
}

