/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyMapProperty;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

public class ObjectDetachOperation {
    protected EntityResolver targetResolver;
    protected Map<ObjectId, Persistent> seen;

    public ObjectDetachOperation(EntityResolver targetResolver) {
        this.targetResolver = targetResolver;
        this.seen = new HashMap<ObjectId, Persistent>();
    }

    public void reset() {
        this.seen.clear();
    }

    public Object detach(Object object, ClassDescriptor descriptor, final PrefetchTreeNode prefetchTree) {
        if (!(object instanceof Persistent)) {
            throw new CayenneRuntimeException("Expected Persistent, got: " + object, new Object[0]);
        }
        final Persistent source = (Persistent)object;
        ObjectId id = source.getObjectId();
        if (id == null) {
            throw new CayenneRuntimeException("Server returned an object without an id: " + source, new Object[0]);
        }
        Persistent seenTarget = this.seen.get(id);
        if (seenTarget != null) {
            return seenTarget;
        }
        descriptor = descriptor.getSubclassDescriptor(source.getClass());
        final ClassDescriptor targetDescriptor = this.targetResolver.getClassDescriptor(id.getEntityName());
        final Persistent target = (Persistent)targetDescriptor.createObject();
        target.setObjectId(id);
        this.seen.put(id, target);
        descriptor.visitProperties(new PropertyVisitor(){

            private void fillReverseRelationship(Object destinationTarget, ArcProperty property) {
                ArcProperty clientReverse;
                ArcProperty clientProperty = (ArcProperty)targetDescriptor.getProperty(property.getName());
                if (clientProperty != null && (clientReverse = clientProperty.getComplimentaryReverseArc()) instanceof ToOneProperty) {
                    clientReverse.writeProperty(destinationTarget, null, target);
                }
            }

            @Override
            public boolean visitToOne(ToOneProperty property) {
                PrefetchTreeNode child;
                if (prefetchTree != null && (child = prefetchTree.getNode(property.getName())) != null) {
                    ToOneProperty targetProperty;
                    Object destinationTarget;
                    Object destinationSource = property.readProperty(source);
                    Object object = destinationTarget = destinationSource != null ? ObjectDetachOperation.this.detach(destinationSource, property.getTargetDescriptor(), child) : null;
                    if (destinationTarget != null) {
                        this.fillReverseRelationship(destinationTarget, property);
                    }
                    Object oldTarget = (targetProperty = (ToOneProperty)targetDescriptor.getProperty(property.getName())).isFault(target) ? null : targetProperty.readProperty(target);
                    targetProperty.writeProperty(target, oldTarget, destinationTarget);
                }
                return true;
            }

            @Override
            public boolean visitToMany(ToManyProperty property) {
                PrefetchTreeNode child;
                if (prefetchTree != null && (child = prefetchTree.getNode(property.getName())) != null) {
                    Cloneable targetValue;
                    Object value = property.readProperty(source);
                    if (property instanceof ToManyMapProperty) {
                        Map map = (Map)value;
                        HashMap targetMap = new HashMap();
                        for (Map.Entry entry : map.entrySet()) {
                            Object destinationTarget;
                            Object destinationSource = entry.getValue();
                            Object object = destinationTarget = destinationSource != null ? ObjectDetachOperation.this.detach(destinationSource, property.getTargetDescriptor(), child) : null;
                            if (destinationTarget != null) {
                                this.fillReverseRelationship(destinationTarget, property);
                            }
                            targetMap.put(entry.getKey(), destinationTarget);
                        }
                        targetValue = targetMap;
                    } else {
                        Collection collection = (Collection)value;
                        ArrayList<Object> targetCollection = new ArrayList<Object>(collection.size());
                        for (Object destinationSource : collection) {
                            Object destinationTarget;
                            Object object = destinationTarget = destinationSource != null ? ObjectDetachOperation.this.detach(destinationSource, property.getTargetDescriptor(), child) : null;
                            if (destinationTarget != null) {
                                this.fillReverseRelationship(destinationTarget, property);
                            }
                            targetCollection.add(destinationTarget);
                        }
                        targetValue = targetCollection;
                    }
                    ToManyProperty targetProperty = (ToManyProperty)targetDescriptor.getProperty(property.getName());
                    targetProperty.writeProperty(target, null, targetValue);
                }
                return true;
            }

            @Override
            public boolean visitAttribute(AttributeProperty property) {
                PropertyDescriptor targetProperty = targetDescriptor.getProperty(property.getName());
                targetProperty.writeProperty(target, null, property.readProperty(source));
                return true;
            }
        });
        return target;
    }
}

