/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.util.PersistentObjectCollection;
import org.apache.cayenne.util.RelationshipFault;
import org.apache.cayenne.util.Util;

public class PersistentObjectSet
extends RelationshipFault
implements Set,
ValueHolder,
PersistentObjectCollection {
    protected Set objectSet;
    protected Set addedToUnresolved;
    protected Set removedFromUnresolved;

    private PersistentObjectSet() {
    }

    public PersistentObjectSet(Persistent relationshipOwner, String relationshipName) {
        super(relationshipOwner, relationshipName);
    }

    @Override
    public boolean isFault() {
        if (this.objectSet != null) {
            return false;
        }
        if (this.isTransientParent()) {
            this.objectSet = new HashSet();
            return false;
        }
        return true;
    }

    @Override
    public void invalidate() {
        this.setObjectSet(null);
    }

    @Override
    public Object setValueDirectly(Object value) throws CayenneRuntimeException {
        Set old = this.objectSet;
        if (value == null || value instanceof Set) {
            this.setObjectSet((Set)value);
        } else if (value instanceof Collection) {
            this.setObjectSet(new HashSet((Collection)value));
        } else {
            throw new CayenneRuntimeException("Value must be a list, got: " + value.getClass().getName(), new Object[0]);
        }
        return old;
    }

    @Override
    public Object getValue() throws CayenneRuntimeException {
        return this.resolvedObjectSet();
    }

    @Override
    public Object getValueDirectly() throws CayenneRuntimeException {
        return this.objectSet;
    }

    @Override
    public Object setValue(Object value) throws CayenneRuntimeException {
        this.resolvedObjectSet();
        return this.setValueDirectly(this.objectSet);
    }

    public void setObjectSet(Set objectSet) {
        this.objectSet = objectSet;
    }

    public boolean add(Object o) {
        if (this.isFault() ? this.addLocal(o) : this.objectSet.add(o)) {
            this.postprocessAdd(o);
            return true;
        }
        return false;
    }

    public boolean addAll(Collection c) {
        if (this.resolvedObjectSet().addAll(c)) {
            this.postprocessAdd(c);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        Set resolved = this.resolvedObjectSet();
        this.postprocessRemove(resolved);
        resolved.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.resolvedObjectSet().contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.resolvedObjectSet().containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof PersistentObjectSet)) {
            return false;
        }
        return this.resolvedObjectSet().equals(((PersistentObjectSet)o).resolvedObjectSet());
    }

    @Override
    public int hashCode() {
        return 53 + this.resolvedObjectSet().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.resolvedObjectSet().isEmpty();
    }

    @Override
    public Iterator iterator() {
        return this.resolvedObjectSet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        if (this.isFault() ? this.removeLocal(o) : this.objectSet.remove(o)) {
            this.postprocessRemove(o);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        if (this.resolvedObjectSet().removeAll(c)) {
            this.postprocessRemove(c);
            return true;
        }
        return false;
    }

    public boolean retainAll(Collection c) {
        HashSet toRemove = new HashSet(this.resolvedObjectSet().size());
        for (Object object : this.resolvedObjectSet()) {
            if (c.contains(object)) continue;
            toRemove.add(object);
        }
        boolean result = this.resolvedObjectSet().retainAll(c);
        if (result) {
            this.postprocessRemove(toRemove);
        }
        return result;
    }

    @Override
    public int size() {
        return this.resolvedObjectSet().size();
    }

    @Override
    public Object[] toArray() {
        return this.resolvedObjectSet().toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.resolvedObjectSet().toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set resolvedObjectSet() {
        if (this.isFault()) {
            PersistentObjectSet persistentObjectSet = this;
            synchronized (persistentObjectSet) {
                if (this.isFault()) {
                    List localList = this.resolveFromDB();
                    this.objectSet = new HashSet(localList);
                }
            }
        }
        return this.objectSet;
    }

    void clearLocalChanges() {
        this.addedToUnresolved = null;
        this.removedFromUnresolved = null;
    }

    @Override
    protected void mergeLocalChanges(List resolved) {
        if (this.isUncommittedParent()) {
            if (this.removedFromUnresolved != null) {
                resolved.removeAll(this.removedFromUnresolved);
            }
            if (this.addedToUnresolved != null) {
                for (Object next : this.addedToUnresolved) {
                    Persistent dataObject;
                    if (next instanceof Persistent && (dataObject = (Persistent)next).getPersistenceState() == 1 || resolved.contains(next)) continue;
                    resolved.add(next);
                }
            }
        }
        this.clearLocalChanges();
    }

    boolean addLocal(Object object) {
        if (this.removedFromUnresolved != null) {
            this.removedFromUnresolved.remove(object);
        }
        if (this.addedToUnresolved == null) {
            this.addedToUnresolved = new HashSet();
        }
        this.addedToUnresolved.add(object);
        return true;
    }

    boolean removeLocal(Object object) {
        if (this.addedToUnresolved != null) {
            this.addedToUnresolved.remove(object);
        }
        if (this.removedFromUnresolved == null) {
            this.removedFromUnresolved = new HashSet();
        }
        this.removedFromUnresolved.add(object);
        return true;
    }

    void postprocessAdd(Collection<?> collection) {
        for (Object next : collection) {
            this.postprocessAdd(next);
        }
    }

    void postprocessRemove(Collection<?> collection) {
        for (Object next : collection) {
            this.postprocessRemove(next);
        }
    }

    void postprocessAdd(Object addedObject) {
        if (this.relationshipOwner.getObjectContext() != null) {
            this.relationshipOwner.getObjectContext().propertyChanged(this.relationshipOwner, this.relationshipName, null, addedObject);
            if (addedObject instanceof Persistent) {
                Util.setReverse(this.relationshipOwner, this.relationshipName, (Persistent)addedObject);
            }
        }
    }

    void postprocessRemove(Object removedObject) {
        if (this.relationshipOwner.getObjectContext() != null) {
            this.relationshipOwner.getObjectContext().propertyChanged(this.relationshipOwner, this.relationshipName, removedObject, null);
            if (removedObject instanceof Persistent) {
                Util.unsetReverse(this.relationshipOwner, this.relationshipName, (Persistent)removedObject);
            }
        }
    }

    public String toString() {
        return this.objectSet != null ? this.objectSet.toString() : "[<unresolved>]";
    }

    @Override
    public void addDirectly(Object target) {
        if (this.isFault()) {
            this.addLocal(target);
        } else {
            this.objectSet.add(target);
        }
    }

    @Override
    public void removeDirectly(Object target) {
        if (this.isFault()) {
            this.removeLocal(target);
        } else {
            this.objectSet.remove(target);
        }
    }
}

