/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.platform.scripting;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngineFactory;
import org.apache.clerezza.platform.scripting.JRubyScriptEngineFactoryWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEngineFactoryManager
implements BundleListener {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ComponentContext componentContext = null;
    private Map<Long, List<ServiceRegistration>> registeredFactories = new HashMap<Long, List<ServiceRegistration>>();
    private final String SERVICE_DEF_PATH = "/META-INF/services/";
    private final String SERVICE_DEF_FILE = "javax.script.ScriptEngineFactory";

    protected void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.registerExistingEngineFactories();
        componentContext.getBundleContext().addBundleListener((BundleListener)this);
    }

    private void registerExistingEngineFactories() {
        Bundle[] bundles;
        if (this.componentContext == null) {
            this.logger.warn("componentContext is null while trying to registerscript engine factories in started bundles");
            return;
        }
        for (Bundle bundle : bundles = this.componentContext.getBundleContext().getBundles()) {
            if (bundle.getState() != 32) continue;
            List<String> engineFactoryNames = this.getEngineFactoryNames(bundle);
            this.registerEngineFactories(bundle, engineFactoryNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getEngineFactoryNames(Bundle bundle) {
        ArrayList<String> engineFactoryNames = new ArrayList<String>();
        BufferedReader in = null;
        try {
            String engineFactoryName;
            URL entry = bundle.getEntry("/META-INF/services/javax.script.ScriptEngineFactory");
            if (entry == null) {
                List<String> list = null;
                return list;
            }
            in = new BufferedReader(new InputStreamReader(entry.openStream()));
            while ((engineFactoryName = in.readLine()) != null) {
                if ((engineFactoryName = engineFactoryName.trim()).isEmpty()) continue;
                engineFactoryNames.add(engineFactoryName);
            }
            in.close();
        }
        catch (IOException ex) {
            this.logger.info("Cannot read {} in bundle {}", (Object)"/META-INF/services/javax.script.ScriptEngineFactory", (Object)bundle.getSymbolicName());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
        return engineFactoryNames;
    }

    private void registerEngineFactories(Bundle bundle, List<String> engineFactoryNames) {
        if (engineFactoryNames == null || engineFactoryNames.isEmpty()) {
            return;
        }
        ArrayList<ServiceRegistration> serviceRegList = new ArrayList<ServiceRegistration>();
        for (String engineFactoryName : engineFactoryNames) {
            try {
                Class<?> factoryClass = Class.forName(engineFactoryName);
                ScriptEngineFactory factory = (ScriptEngineFactory)factoryClass.newInstance();
                String[] clazzes = new String[]{engineFactoryName, "javax.script.ScriptEngineFactory"};
                ServiceRegistration serviceReg = this.componentContext.getBundleContext().registerService(clazzes, (Object)factory, null);
                serviceRegList.add(serviceReg);
                if (!engineFactoryName.equals("com.sun.script.jruby.JRubyScriptEngineFactory")) continue;
                factory = new JRubyScriptEngineFactoryWrapper((ScriptEngineFactory)factoryClass.newInstance());
                String[] wrappedClazzes = new String[]{"org.apache.clerezza.platform.scripting.JRubyScriptEngineFactoryWrapper", "javax.script.ScriptEngineFactory"};
                serviceRegList.add(this.componentContext.getBundleContext().registerService(wrappedClazzes, (Object)factory, null));
            }
            catch (InstantiationException ex) {
                this.logger.warn("Cannot instantiate {}", (Object)engineFactoryName);
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (ClassNotFoundException ex) {
                this.logger.warn("Cannot find class {}", (Object)engineFactoryName);
                throw new RuntimeException(ex);
            }
        }
        long bundleId = bundle.getBundleId();
        this.registeredFactories.put(bundleId, serviceRegList);
    }

    protected void deactivate(ComponentContext componentContext) {
        this.deregisterEngineFactories();
        componentContext.getBundleContext().removeBundleListener((BundleListener)this);
        this.componentContext = null;
    }

    private void deregisterEngineFactories() {
        Iterator<List<ServiceRegistration>> serviceRegLists = this.registeredFactories.values().iterator();
        while (serviceRegLists.hasNext()) {
            for (ServiceRegistration serviceReg : serviceRegLists.next()) {
                serviceReg.unregister();
            }
        }
        this.registeredFactories.clear();
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 2: {
                this.registerEngineFactories(bundle, this.getEngineFactoryNames(bundle));
                break;
            }
            case 4: {
                long bundleId = bundle.getBundleId();
                List<ServiceRegistration> serviceRegList = this.registeredFactories.get(bundleId);
                if (serviceRegList == null || serviceRegList.isEmpty()) break;
                for (ServiceRegistration serviceReg : serviceRegList) {
                    serviceReg.unregister();
                }
                this.registeredFactories.remove(bundleId);
            }
        }
    }
}

