/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.platform.scripting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.clerezza.platform.content.DiscobitsHandler;
import org.apache.clerezza.platform.graphprovider.content.ContentGraphProvider;
import org.apache.clerezza.platform.scripting.NoEngineException;
import org.apache.clerezza.platform.scripting.ScriptLanguageDescription;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.TypedLiteral;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.LockableMGraph;
import org.apache.clerezza.rdf.core.access.TcManager;
import org.apache.clerezza.rdf.core.serializedform.Parser;
import org.apache.clerezza.rdf.ontologies.SCRIPT;
import org.apache.clerezza.rdf.utils.GraphNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptExecution {
    private ContentGraphProvider cgProvider;
    private DiscobitsHandler contentHandler;
    private TcManager tcManager;
    private Parser parser;
    private Map<ScriptLanguageDescription, List<ScriptEngineFactory>> languageToFactoryMap = new HashMap<ScriptLanguageDescription, List<ScriptEngineFactory>>();
    private static final Logger logger = LoggerFactory.getLogger(ScriptExecution.class);

    public Object execute(NonLiteral scriptResource) throws ScriptException, NoEngineException {
        return this.execute(scriptResource, null);
    }

    public Object execute(NonLiteral scriptResource, Bindings bindings) throws ScriptException, NoEngineException {
        Object result;
        LockableMGraph contentGraph = this.cgProvider.getContentGraph();
        String scriptString = null;
        String scriptLanguage = null;
        String scriptLanguageVersion = null;
        String scriptProducedType = "text/plain";
        GraphNode scriptNode = new GraphNode((Resource)scriptResource, (TripleCollection)contentGraph);
        Iterator it = scriptNode.getObjects(SCRIPT.scriptLanguage);
        scriptLanguage = (String)LiteralFactory.getInstance().createObject(String.class, (TypedLiteral)it.next());
        it = scriptNode.getObjects(SCRIPT.scriptLanguageVersion);
        scriptLanguageVersion = (String)LiteralFactory.getInstance().createObject(String.class, (TypedLiteral)it.next());
        it = scriptNode.getObjects(SCRIPT.producedType);
        if (it.hasNext()) {
            scriptProducedType = (String)LiteralFactory.getInstance().createObject(String.class, (TypedLiteral)it.next());
        }
        if ((result = this.execute(scriptString = new String(this.contentHandler.getData((UriRef)scriptResource)), bindings, scriptLanguage, scriptLanguageVersion)) instanceof GraphNode) {
            return result;
        }
        return Response.ok((Object)result, (MediaType)MediaType.valueOf((String)scriptProducedType)).build();
    }

    public Object execute(String script, Bindings bindings, String language, String languageVersion) throws ScriptException, NoEngineException {
        ScriptEngine engine = this.getScriptEngine(language, languageVersion);
        if (engine == null) {
            logger.warn("Cannot execute script: No engine available for language {}({})", (Object)language, (Object)languageVersion);
            throw new NoEngineException(new ScriptLanguageDescription(language, languageVersion));
        }
        if (bindings == null) {
            bindings = engine.createBindings();
        }
        this.addBindings(bindings);
        return engine.eval(script, bindings);
    }

    private void addBindings(Bindings bindings) {
        bindings.put("contentGraphProvider", (Object)this.cgProvider);
        bindings.put("contentHandler", (Object)this.contentHandler);
        bindings.put("tcManager", (Object)this.tcManager);
        bindings.put("parser", (Object)this.parser);
    }

    private ScriptEngine getScriptEngine(String language, String languageVersion) {
        List<ScriptEngineFactory> factoryList = null;
        try {
            factoryList = this.languageToFactoryMap.get(new ScriptLanguageDescription(language, languageVersion));
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        if (factoryList == null || factoryList.isEmpty()) {
            return null;
        }
        return factoryList.get(factoryList.size() - 1).getScriptEngine();
    }

    public Iterator<ScriptLanguageDescription> getInstalledScriptLanguages() {
        return this.languageToFactoryMap.keySet().iterator();
    }

    protected void bindScriptEngineFactory(ScriptEngineFactory factory) {
        String language = factory.getLanguageName();
        String languageVersion = factory.getLanguageVersion();
        this.addScriptEngineFactory(new ScriptLanguageDescription(language, languageVersion), factory);
    }

    private void addScriptEngineFactory(ScriptLanguageDescription language, ScriptEngineFactory factory) {
        List<ScriptEngineFactory> factoryList = this.languageToFactoryMap.get(language);
        if (factoryList == null) {
            factoryList = new ArrayList<ScriptEngineFactory>();
        } else if (factoryList.contains(factory)) {
            return;
        }
        factoryList.add(factory);
        this.languageToFactoryMap.put(language, factoryList);
    }

    protected void unbindScriptEngineFactory(ScriptEngineFactory factory) {
        String language = factory.getLanguageName();
        String languageVersion = factory.getLanguageVersion();
        this.removeScriptEngineFactory(new ScriptLanguageDescription(language, languageVersion), factory);
    }

    private void removeScriptEngineFactory(ScriptLanguageDescription language, ScriptEngineFactory factory) {
        List<ScriptEngineFactory> factoryList = this.languageToFactoryMap.get(language);
        if (factoryList != null) {
            factoryList.remove(factory);
            if (factoryList.isEmpty()) {
                this.languageToFactoryMap.remove(language);
            }
        }
    }

    protected void bindCgProvider(ContentGraphProvider contentGraphProvider) {
        this.cgProvider = contentGraphProvider;
    }

    protected void unbindCgProvider(ContentGraphProvider contentGraphProvider) {
        if (this.cgProvider == contentGraphProvider) {
            this.cgProvider = null;
        }
    }

    protected void bindContentHandler(DiscobitsHandler discobitsHandler) {
        this.contentHandler = discobitsHandler;
    }

    protected void unbindContentHandler(DiscobitsHandler discobitsHandler) {
        if (this.contentHandler == discobitsHandler) {
            this.contentHandler = null;
        }
    }

    protected void bindTcManager(TcManager tcManager) {
        this.tcManager = tcManager;
    }

    protected void unbindTcManager(TcManager tcManager) {
        if (this.tcManager == tcManager) {
            this.tcManager = null;
        }
    }

    protected void bindParser(Parser parser) {
        this.parser = parser;
    }

    protected void unbindParser(Parser parser) {
        if (this.parser == parser) {
            this.parser = null;
        }
    }
}

