/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.platform.scripting;

import java.util.Iterator;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.ws.rs.GET;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.clerezza.jaxrs.utils.TrailingSlash;
import org.apache.clerezza.platform.graphprovider.content.ContentGraphProvider;
import org.apache.clerezza.platform.scripting.ScriptExecution;
import org.apache.clerezza.platform.typehandlerspace.SupportedTypes;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.ontologies.SCRIPT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedTypes(types={"http://clerezza.org/2009/07/script#ScriptGeneratedResource"}, prioritize=true)
public class ScriptGeneratedResourceTypeHandler {
    private static final Logger logger = LoggerFactory.getLogger(ScriptGeneratedResourceTypeHandler.class);
    private ContentGraphProvider cgProvider;
    private ScriptExecution scriptExecution;

    @GET
    public Object get(@Context UriInfo uriInfo, @Context Request request, @Context HttpHeaders httpHeaders) {
        TrailingSlash.enforceNotPresent((UriInfo)uriInfo);
        UriRef requestUri = new UriRef(uriInfo.getAbsolutePath().toString());
        Iterator it = this.cgProvider.getContentGraph().filter((NonLiteral)requestUri, SCRIPT.scriptSource, null);
        if (it.hasNext()) {
            NonLiteral scriptResource = (NonLiteral)((Triple)it.next()).getObject();
            try {
                SimpleBindings bindings = new SimpleBindings();
                bindings.put("uriInfo", (Object)uriInfo);
                bindings.put("request", (Object)request);
                bindings.put("httpHeaders", (Object)httpHeaders);
                return this.scriptExecution.execute(scriptResource, bindings);
            }
            catch (ScriptException ex) {
                logger.warn("Exception while executing script {}", (Object)((UriRef)scriptResource).getUnicodeString());
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getMessage()).build());
            }
        }
        logger.warn("There is no script associated with {}", (Object)requestUri.getUnicodeString());
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    protected void bindCgProvider(ContentGraphProvider contentGraphProvider) {
        this.cgProvider = contentGraphProvider;
    }

    protected void unbindCgProvider(ContentGraphProvider contentGraphProvider) {
        if (this.cgProvider == contentGraphProvider) {
            this.cgProvider = null;
        }
    }

    protected void bindScriptExecution(ScriptExecution scriptExecution) {
        this.scriptExecution = scriptExecution;
    }

    protected void unbindScriptExecution(ScriptExecution scriptExecution) {
        if (this.scriptExecution == scriptExecution) {
            this.scriptExecution = null;
        }
    }
}

