/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.platform.scripting;

public class ScriptLanguageDescription {
    private final String language;
    private final String version;

    public ScriptLanguageDescription(String language, String version) throws IllegalArgumentException {
        if (language == null) {
            throw new IllegalArgumentException("Script Language can not be null");
        }
        if (version == null) {
            version = "";
        }
        this.language = language;
        this.version = version;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        return (this.language + this.version).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj.getClass().getName().equals(this.getClass().getName())) {
            ScriptLanguageDescription sld = (ScriptLanguageDescription)obj;
            return this.language.equals(sld.language) && this.version.equals(sld.version);
        }
        return false;
    }

    public String toString() {
        return this.language + " " + this.version;
    }
}

