/*
 * $Id$
 */

package org.apache.continuum.xmlrpc.release;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.project.AddingResult;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinition;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.xmlrpc.project.BuildProjectTask;
import org.apache.maven.continuum.xmlrpc.project.BuildResult;
import org.apache.maven.continuum.xmlrpc.project.BuildResultSummary;
import org.apache.maven.continuum.xmlrpc.project.ContinuumProjectState;
import org.apache.maven.continuum.xmlrpc.project.Project;
import org.apache.maven.continuum.xmlrpc.project.ProjectDependency;
import org.apache.maven.continuum.xmlrpc.project.ProjectDeveloper;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroup;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroupSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectNotifier;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;
import org.apache.maven.continuum.xmlrpc.project.Schedule;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * Class ContinuumReleaseResult.
 * 
 * @version $Revision$ $Date$
 */
public class ContinuumReleaseResult implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id.
     */
    private int id = 0;

    /**
     * Field startTime.
     */
    private long startTime = 0;

    /**
     * Field endTime.
     */
    private long endTime = 0;

    /**
     * Field resultCode.
     */
    private int resultCode = 0;

    /**
     * Field projectGroup.
     */
    private ProjectGroup projectGroup;

    /**
     * Field project.
     */
    private Project project;

    /**
     * Field releaseGoal.
     */
    private String releaseGoal;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof ContinuumReleaseResult) )
        {
            return false;
        }
        
        ContinuumReleaseResult that = (ContinuumReleaseResult) other;
        boolean result = true;
        
        result = result && id == that.id;
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get the endTime field.
     * 
     * @return long
     */
    public long getEndTime()
    {
        return this.endTime;
    } //-- long getEndTime() 

    /**
     * Get the id field.
     * 
     * @return int
     */
    public int getId()
    {
        return this.id;
    } //-- int getId() 

    /**
     * Get the project field.
     * 
     * @return Project
     */
    public Project getProject()
    {
        return this.project;
    } //-- Project getProject() 

    /**
     * Get the projectGroup field.
     * 
     * @return ProjectGroup
     */
    public ProjectGroup getProjectGroup()
    {
        return this.projectGroup;
    } //-- ProjectGroup getProjectGroup() 

    /**
     * Get the releaseGoal field.
     * 
     * @return String
     */
    public String getReleaseGoal()
    {
        return this.releaseGoal;
    } //-- String getReleaseGoal() 

    /**
     * Get the resultCode field.
     * 
     * @return int
     */
    public int getResultCode()
    {
        return this.resultCode;
    } //-- int getResultCode() 

    /**
     * Get the startTime field.
     * 
     * @return long
     */
    public long getStartTime()
    {
        return this.startTime;
    } //-- long getStartTime() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + (int) id;
        
        return result;
    } //-- int hashCode() 

    /**
     * Set the endTime field.
     * 
     * @param endTime
     */
    public void setEndTime(long endTime)
    {
        this.endTime = endTime;
    } //-- void setEndTime(long) 

    /**
     * Set the id field.
     * 
     * @param id
     */
    public void setId(int id)
    {
        this.id = id;
    } //-- void setId(int) 

    /**
     * Set the project field.
     * 
     * @param project
     */
    public void setProject(Project project)
    {
        this.project = project;
    } //-- void setProject(Project) 

    /**
     * Set the projectGroup field.
     * 
     * @param projectGroup
     */
    public void setProjectGroup(ProjectGroup projectGroup)
    {
        this.projectGroup = projectGroup;
    } //-- void setProjectGroup(ProjectGroup) 

    /**
     * Set the releaseGoal field.
     * 
     * @param releaseGoal
     */
    public void setReleaseGoal(String releaseGoal)
    {
        this.releaseGoal = releaseGoal;
    } //-- void setReleaseGoal(String) 

    /**
     * Set the resultCode field.
     * 
     * @param resultCode
     */
    public void setResultCode(int resultCode)
    {
        this.resultCode = resultCode;
    } //-- void setResultCode(int) 

    /**
     * Set the startTime field.
     * 
     * @param startTime
     */
    public void setStartTime(long startTime)
    {
        this.startTime = startTime;
    } //-- void setStartTime(long) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "id = '" );
        buf.append( getId() );
        buf.append( "'" );
        
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
