/*
 * $Id$
 */

package org.apache.continuum.xmlrpc.repository;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.maven.continuum.xmlrpc.project.AddingResult;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinition;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.xmlrpc.project.BuildProjectTask;
import org.apache.maven.continuum.xmlrpc.project.BuildResult;
import org.apache.maven.continuum.xmlrpc.project.BuildResultSummary;
import org.apache.maven.continuum.xmlrpc.project.ContinuumProjectState;
import org.apache.maven.continuum.xmlrpc.project.Project;
import org.apache.maven.continuum.xmlrpc.project.ProjectDependency;
import org.apache.maven.continuum.xmlrpc.project.ProjectDeveloper;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroup;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroupSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectNotifier;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;
import org.apache.maven.continuum.xmlrpc.project.Schedule;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * Class AbstractPurgeConfiguration.
 * 
 * @version $Revision$ $Date$
 */
public class AbstractPurgeConfiguration implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id.
     */
    private int id = 0;

    /**
     * Field description.
     */
    private String description;

    /**
     * Field deleteAll.
     */
    private boolean deleteAll = false;

    /**
     * 
     *           The total count of the artifact for each snapshot
     * or the release/build output folder to be retained.
     *           
     */
    private int retentionCount = 2;

    /**
     * 
     *           The number of days old which will be the basis for
     * removing a snapshot or a folder.
     *           
     */
    private int daysOlder = 100;

    /**
     * Field enabled.
     */
    private boolean enabled = true;

    /**
     * Field schedule.
     */
    private Schedule schedule;

    /**
     * Field defaultPurge.
     */
    private boolean defaultPurge = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof AbstractPurgeConfiguration) )
        {
            return false;
        }
        
        AbstractPurgeConfiguration that = (AbstractPurgeConfiguration) other;
        boolean result = true;
        
        result = result && id == that.id;
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get 
     *           The number of days old which will be the basis for
     * removing a snapshot or a folder.
     *           
     * 
     * @return int
     */
    public int getDaysOlder()
    {
        return this.daysOlder;
    } //-- int getDaysOlder() 

    /**
     * Get the description field.
     * 
     * @return String
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Get the id field.
     * 
     * @return int
     */
    public int getId()
    {
        return this.id;
    } //-- int getId() 

    /**
     * Get 
     *           The total count of the artifact for each snapshot
     * or the release/build output folder to be retained.
     *           
     * 
     * @return int
     */
    public int getRetentionCount()
    {
        return this.retentionCount;
    } //-- int getRetentionCount() 

    /**
     * Get the schedule field.
     * 
     * @return Schedule
     */
    public Schedule getSchedule()
    {
        return this.schedule;
    } //-- Schedule getSchedule() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + (int) id;
        
        return result;
    } //-- int hashCode() 

    /**
     * Get the defaultPurge field.
     * 
     * @return boolean
     */
    public boolean isDefaultPurge()
    {
        return this.defaultPurge;
    } //-- boolean isDefaultPurge() 

    /**
     * Get the deleteAll field.
     * 
     * @return boolean
     */
    public boolean isDeleteAll()
    {
        return this.deleteAll;
    } //-- boolean isDeleteAll() 

    /**
     * Get the enabled field.
     * 
     * @return boolean
     */
    public boolean isEnabled()
    {
        return this.enabled;
    } //-- boolean isEnabled() 

    /**
     * Set 
     *           The number of days old which will be the basis for
     * removing a snapshot or a folder.
     *           
     * 
     * @param daysOlder
     */
    public void setDaysOlder(int daysOlder)
    {
        this.daysOlder = daysOlder;
    } //-- void setDaysOlder(int) 

    /**
     * Set the defaultPurge field.
     * 
     * @param defaultPurge
     */
    public void setDefaultPurge(boolean defaultPurge)
    {
        this.defaultPurge = defaultPurge;
    } //-- void setDefaultPurge(boolean) 

    /**
     * Set the deleteAll field.
     * 
     * @param deleteAll
     */
    public void setDeleteAll(boolean deleteAll)
    {
        this.deleteAll = deleteAll;
    } //-- void setDeleteAll(boolean) 

    /**
     * Set the description field.
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Set the enabled field.
     * 
     * @param enabled
     */
    public void setEnabled(boolean enabled)
    {
        this.enabled = enabled;
    } //-- void setEnabled(boolean) 

    /**
     * Set the id field.
     * 
     * @param id
     */
    public void setId(int id)
    {
        this.id = id;
    } //-- void setId(int) 

    /**
     * Set 
     *           The total count of the artifact for each snapshot
     * or the release/build output folder to be retained.
     *           
     * 
     * @param retentionCount
     */
    public void setRetentionCount(int retentionCount)
    {
        this.retentionCount = retentionCount;
    } //-- void setRetentionCount(int) 

    /**
     * Set the schedule field.
     * 
     * @param schedule
     */
    public void setSchedule(Schedule schedule)
    {
        this.schedule = schedule;
    } //-- void setSchedule(Schedule) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "id = '" );
        buf.append( getId() );
        buf.append( "'" );
        
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
