/*
 * $Id$
 */

package org.apache.continuum.xmlrpc.repository;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.maven.continuum.xmlrpc.project.AddingResult;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinition;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.xmlrpc.project.BuildProjectTask;
import org.apache.maven.continuum.xmlrpc.project.BuildResult;
import org.apache.maven.continuum.xmlrpc.project.BuildResultSummary;
import org.apache.maven.continuum.xmlrpc.project.ContinuumProjectState;
import org.apache.maven.continuum.xmlrpc.project.Project;
import org.apache.maven.continuum.xmlrpc.project.ProjectDependency;
import org.apache.maven.continuum.xmlrpc.project.ProjectDeveloper;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroup;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroupSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectNotifier;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;
import org.apache.maven.continuum.xmlrpc.project.Schedule;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * Class DirectoryPurgeConfiguration.
 * 
 * @version $Revision$ $Date$
 */
public class DirectoryPurgeConfiguration extends AbstractPurgeConfiguration 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The file system path for this directory
     *           .
     */
    private String location;

    /**
     * 
     *             The type of directory. Valid values are
     * "releases" and "buildOutput"
     *           .
     */
    private String directoryType;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The type of directory. Valid values are
     * "releases" and "buildOutput"
     *           .
     * 
     * @return String
     */
    public String getDirectoryType()
    {
        return this.directoryType;
    } //-- String getDirectoryType() 

    /**
     * Get 
     *             The file system path for this directory
     *           .
     * 
     * @return String
     */
    public String getLocation()
    {
        return this.location;
    } //-- String getLocation() 

    /**
     * Set 
     *             The type of directory. Valid values are
     * "releases" and "buildOutput"
     *           .
     * 
     * @param directoryType
     */
    public void setDirectoryType(String directoryType)
    {
        this.directoryType = directoryType;
    } //-- void setDirectoryType(String) 

    /**
     * Set 
     *             The file system path for this directory
     *           .
     * 
     * @param location
     */
    public void setLocation(String location)
    {
        this.location = location;
    } //-- void setLocation(String) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
