/*
 * $Id$
 */

package org.apache.continuum.xmlrpc.repository;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.maven.continuum.xmlrpc.project.AddingResult;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinition;
import org.apache.maven.continuum.xmlrpc.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.xmlrpc.project.BuildProjectTask;
import org.apache.maven.continuum.xmlrpc.project.BuildResult;
import org.apache.maven.continuum.xmlrpc.project.BuildResultSummary;
import org.apache.maven.continuum.xmlrpc.project.ContinuumProjectState;
import org.apache.maven.continuum.xmlrpc.project.Project;
import org.apache.maven.continuum.xmlrpc.project.ProjectDependency;
import org.apache.maven.continuum.xmlrpc.project.ProjectDeveloper;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroup;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroupSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectNotifier;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;
import org.apache.maven.continuum.xmlrpc.project.Schedule;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * Class RepositoryPurgeConfiguration.
 * 
 * @version $Revision$ $Date$
 */
public class RepositoryPurgeConfiguration extends AbstractPurgeConfiguration 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field repository.
     */
    private LocalRepository repository;

    /**
     * 
     *             True if the released snapshots are to be removed
     * from the repo during repository purge.
     *           
     */
    private boolean deleteReleasedSnapshots = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get the repository field.
     * 
     * @return LocalRepository
     */
    public LocalRepository getRepository()
    {
        return this.repository;
    } //-- LocalRepository getRepository() 

    /**
     * Get 
     *             True if the released snapshots are to be removed
     * from the repo during repository purge.
     *           
     * 
     * @return boolean
     */
    public boolean isDeleteReleasedSnapshots()
    {
        return this.deleteReleasedSnapshots;
    } //-- boolean isDeleteReleasedSnapshots() 

    /**
     * Set 
     *             True if the released snapshots are to be removed
     * from the repo during repository purge.
     *           
     * 
     * @param deleteReleasedSnapshots
     */
    public void setDeleteReleasedSnapshots(boolean deleteReleasedSnapshots)
    {
        this.deleteReleasedSnapshots = deleteReleasedSnapshots;
    } //-- void setDeleteReleasedSnapshots(boolean) 

    /**
     * Set the repository field.
     * 
     * @param repository
     */
    public void setRepository(LocalRepository repository)
    {
        this.repository = repository;
    } //-- void setRepository(LocalRepository) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
