/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * 
 *         This class is the result of add maven project action.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class AddingResult implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field projects.
     */
    private java.util.List projects;

    /**
     * Field projectGroups.
     */
    private java.util.List projectGroups;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addProject.
     * 
     * @param projectSummary
     */
    public void addProject(ProjectSummary projectSummary)
    {
        if ( !(projectSummary instanceof ProjectSummary) )
        {
            throw new ClassCastException( "AddingResult.addProjects(projectSummary) parameter must be instanceof " + ProjectSummary.class.getName() );
        }
        getProjects().add( projectSummary );
    } //-- void addProject(ProjectSummary) 

    /**
     * Method addProjectGroup.
     * 
     * @param projectGroupSummary
     */
    public void addProjectGroup(ProjectGroupSummary projectGroupSummary)
    {
        if ( !(projectGroupSummary instanceof ProjectGroupSummary) )
        {
            throw new ClassCastException( "AddingResult.addProjectGroups(projectGroupSummary) parameter must be instanceof " + ProjectGroupSummary.class.getName() );
        }
        getProjectGroups().add( projectGroupSummary );
    } //-- void addProjectGroup(ProjectGroupSummary) 

    /**
     * Method getProjectGroups.
     * 
     * @return java.util.List
     */
    public java.util.List getProjectGroups()
    {
        if ( this.projectGroups == null )
        {
            this.projectGroups = new java.util.ArrayList();
        }
        
        return this.projectGroups;
    } //-- java.util.List getProjectGroups() 

    /**
     * Method getProjects.
     * 
     * @return java.util.List
     */
    public java.util.List getProjects()
    {
        if ( this.projects == null )
        {
            this.projects = new java.util.ArrayList();
        }
        
        return this.projects;
    } //-- java.util.List getProjects() 

    /**
     * Method removeProject.
     * 
     * @param projectSummary
     */
    public void removeProject(ProjectSummary projectSummary)
    {
        if ( !(projectSummary instanceof ProjectSummary) )
        {
            throw new ClassCastException( "AddingResult.removeProjects(projectSummary) parameter must be instanceof " + ProjectSummary.class.getName() );
        }
        getProjects().remove( projectSummary );
    } //-- void removeProject(ProjectSummary) 

    /**
     * Method removeProjectGroup.
     * 
     * @param projectGroupSummary
     */
    public void removeProjectGroup(ProjectGroupSummary projectGroupSummary)
    {
        if ( !(projectGroupSummary instanceof ProjectGroupSummary) )
        {
            throw new ClassCastException( "AddingResult.removeProjectGroups(projectGroupSummary) parameter must be instanceof " + ProjectGroupSummary.class.getName() );
        }
        getProjectGroups().remove( projectGroupSummary );
    } //-- void removeProjectGroup(ProjectGroupSummary) 

    /**
     * Set the projectGroups field.
     * 
     * @param projectGroups
     */
    public void setProjectGroups(java.util.List projectGroups)
    {
        this.projectGroups = projectGroups;
    } //-- void setProjectGroups(java.util.List) 

    /**
     * Set the projects field.
     * 
     * @param projects
     */
    public void setProjects(java.util.List projects)
    {
        this.projects = projects;
    } //-- void setProjects(java.util.List) 


            private java.util.List errors = new java.util.ArrayList();

            /**
             * Add an error that happened during adding the project to Continuum.
             *
             * @param errorKey error id (so it can be internationalized later)
             */
            public void addError( String errorKey )
            {
                errors.add( errorKey );
            }

            /**
             * Get the errors that happened during adding the project to Continuum.
             * There is an entry with the error key (so it can be internationalized later) for each error.
             *
             * @return {@link java.util.List} &lt; {@link String} >
             */
            public java.util.List getErrors()
            {
                return errors;
            }

            /**
             * Quick check to see if there are any errors.
             *
             * @return boolean indicating if there are any errors.
             */
            public boolean hasErrors()
            {
                return ( errors != null ) && ( !errors.isEmpty() );
            }

            /**
             * Returns a string representation of the errors.
             *
             * @return a string representation of the errors.
             */
            public String getErrorsAsString()
            {
                if ( !hasErrors() )
                {
                    return null;
                }

                StringBuffer message = new StringBuffer();
                for ( java.util.Iterator i = errors.iterator(); i.hasNext(); )
                {
                    String error = (String) i.next();
                    message.append( error );
                    message.append( "\n" );
                }
                return message.toString();
            }
          
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
