/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * Class BuildDefinition.
 * 
 * @version $Revision$ $Date$
 */
public class BuildDefinition implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id.
     */
    private int id = 0;

    /**
     * Field defaultForProject.
     */
    private boolean defaultForProject = false;

    /**
     * Field goals.
     */
    private String goals;

    /**
     * Field arguments.
     */
    private String arguments;

    /**
     * Field buildFile.
     */
    private String buildFile;

    /**
     * 
     *             true if the build is to be smoked and checked
     * back out from the scm each build
     *           .
     */
    private boolean buildFresh = false;

    /**
     * description of the buid defintion.
     */
    private String description;

    /**
     * type of the buid defintion.
     */
    private String type;

    /**
     * Field schedule.
     */
    private Schedule schedule;

    /**
     * Field profile.
     */
    private Profile profile;

    /**
     * 
     *             true if the build had to be forced even if there
     * is no scm change
     *           .
     */
    private boolean alwaysBuild = false;

    /**
     * 
     *             true if this buildDefinition is a template
     *           .
     */
    private boolean template = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof BuildDefinition) )
        {
            return false;
        }
        
        BuildDefinition that = (BuildDefinition) other;
        boolean result = true;
        
        result = result && id == that.id;
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get the arguments field.
     * 
     * @return String
     */
    public String getArguments()
    {
        return this.arguments;
    } //-- String getArguments() 

    /**
     * Get the buildFile field.
     * 
     * @return String
     */
    public String getBuildFile()
    {
        return this.buildFile;
    } //-- String getBuildFile() 

    /**
     * Get description of the buid defintion.
     * 
     * @return String
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Get the goals field.
     * 
     * @return String
     */
    public String getGoals()
    {
        return this.goals;
    } //-- String getGoals() 

    /**
     * Get the id field.
     * 
     * @return int
     */
    public int getId()
    {
        return this.id;
    } //-- int getId() 

    /**
     * Get the profile field.
     * 
     * @return Profile
     */
    public Profile getProfile()
    {
        return this.profile;
    } //-- Profile getProfile() 

    /**
     * Get the schedule field.
     * 
     * @return Schedule
     */
    public Schedule getSchedule()
    {
        return this.schedule;
    } //-- Schedule getSchedule() 

    /**
     * Get type of the buid defintion.
     * 
     * @return String
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + (int) id;
        
        return result;
    } //-- int hashCode() 

    /**
     * Get 
     *             true if the build had to be forced even if there
     * is no scm change
     *           .
     * 
     * @return boolean
     */
    public boolean isAlwaysBuild()
    {
        return this.alwaysBuild;
    } //-- boolean isAlwaysBuild() 

    /**
     * Get 
     *             true if the build is to be smoked and checked
     * back out from the scm each build
     *           .
     * 
     * @return boolean
     */
    public boolean isBuildFresh()
    {
        return this.buildFresh;
    } //-- boolean isBuildFresh() 

    /**
     * Get the defaultForProject field.
     * 
     * @return boolean
     */
    public boolean isDefaultForProject()
    {
        return this.defaultForProject;
    } //-- boolean isDefaultForProject() 

    /**
     * Get 
     *             true if this buildDefinition is a template
     *           .
     * 
     * @return boolean
     */
    public boolean isTemplate()
    {
        return this.template;
    } //-- boolean isTemplate() 

    /**
     * Set 
     *             true if the build had to be forced even if there
     * is no scm change
     *           .
     * 
     * @param alwaysBuild
     */
    public void setAlwaysBuild(boolean alwaysBuild)
    {
        this.alwaysBuild = alwaysBuild;
    } //-- void setAlwaysBuild(boolean) 

    /**
     * Set the arguments field.
     * 
     * @param arguments
     */
    public void setArguments(String arguments)
    {
        this.arguments = arguments;
    } //-- void setArguments(String) 

    /**
     * Set the buildFile field.
     * 
     * @param buildFile
     */
    public void setBuildFile(String buildFile)
    {
        this.buildFile = buildFile;
    } //-- void setBuildFile(String) 

    /**
     * Set 
     *             true if the build is to be smoked and checked
     * back out from the scm each build
     *           .
     * 
     * @param buildFresh
     */
    public void setBuildFresh(boolean buildFresh)
    {
        this.buildFresh = buildFresh;
    } //-- void setBuildFresh(boolean) 

    /**
     * Set the defaultForProject field.
     * 
     * @param defaultForProject
     */
    public void setDefaultForProject(boolean defaultForProject)
    {
        this.defaultForProject = defaultForProject;
    } //-- void setDefaultForProject(boolean) 

    /**
     * Set description of the buid defintion.
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Set the goals field.
     * 
     * @param goals
     */
    public void setGoals(String goals)
    {
        this.goals = goals;
    } //-- void setGoals(String) 

    /**
     * Set the id field.
     * 
     * @param id
     */
    public void setId(int id)
    {
        this.id = id;
    } //-- void setId(int) 

    /**
     * Set the profile field.
     * 
     * @param profile
     */
    public void setProfile(Profile profile)
    {
        this.profile = profile;
    } //-- void setProfile(Profile) 

    /**
     * Set the schedule field.
     * 
     * @param schedule
     */
    public void setSchedule(Schedule schedule)
    {
        this.schedule = schedule;
    } //-- void setSchedule(Schedule) 

    /**
     * Set 
     *             true if this buildDefinition is a template
     *           .
     * 
     * @param template
     */
    public void setTemplate(boolean template)
    {
        this.template = template;
    } //-- void setTemplate(boolean) 

    /**
     * Set type of the buid defintion.
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    } //-- void setType(String) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "id = '" );
        buf.append( getId() );
        buf.append( "'" );
        
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
