/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * Template which contains some buildDefinitions.
 * 
 * @version $Revision$ $Date$
 */
public class BuildDefinitionTemplate implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id.
     */
    private int id = 0;

    /**
     * Field name.
     */
    private String name;

    /**
     * 
     *             true if this definition is a continuum default
     * build def (cannot be removed)
     *           .
     */
    private boolean continuumDefault = false;

    /**
     * type of the buid BuildDefinitionTemplate use for default.
     */
    private String type;

    /**
     * Field buildDefinitions.
     */
    private java.util.List buildDefinitions;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addBuildDefinition.
     * 
     * @param buildDefinition
     */
    public void addBuildDefinition(BuildDefinition buildDefinition)
    {
        if ( !(buildDefinition instanceof BuildDefinition) )
        {
            throw new ClassCastException( "BuildDefinitionTemplate.addBuildDefinitions(buildDefinition) parameter must be instanceof " + BuildDefinition.class.getName() );
        }
        getBuildDefinitions().add( buildDefinition );
    } //-- void addBuildDefinition(BuildDefinition) 

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof BuildDefinitionTemplate) )
        {
            return false;
        }
        
        BuildDefinitionTemplate that = (BuildDefinitionTemplate) other;
        boolean result = true;
        
        result = result && id == that.id;
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Method getBuildDefinitions.
     * 
     * @return java.util.List
     */
    public java.util.List getBuildDefinitions()
    {
        if ( this.buildDefinitions == null )
        {
            this.buildDefinitions = new java.util.ArrayList();
        }
        
        return this.buildDefinitions;
    } //-- java.util.List getBuildDefinitions() 

    /**
     * Get the id field.
     * 
     * @return int
     */
    public int getId()
    {
        return this.id;
    } //-- int getId() 

    /**
     * Get the name field.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get type of the buid BuildDefinitionTemplate use for
     * default.
     * 
     * @return String
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + (int) id;
        
        return result;
    } //-- int hashCode() 

    /**
     * Get 
     *             true if this definition is a continuum default
     * build def (cannot be removed)
     *           .
     * 
     * @return boolean
     */
    public boolean isContinuumDefault()
    {
        return this.continuumDefault;
    } //-- boolean isContinuumDefault() 

    /**
     * Method removeBuildDefinition.
     * 
     * @param buildDefinition
     */
    public void removeBuildDefinition(BuildDefinition buildDefinition)
    {
        if ( !(buildDefinition instanceof BuildDefinition) )
        {
            throw new ClassCastException( "BuildDefinitionTemplate.removeBuildDefinitions(buildDefinition) parameter must be instanceof " + BuildDefinition.class.getName() );
        }
        getBuildDefinitions().remove( buildDefinition );
    } //-- void removeBuildDefinition(BuildDefinition) 

    /**
     * Set the buildDefinitions field.
     * 
     * @param buildDefinitions
     */
    public void setBuildDefinitions(java.util.List buildDefinitions)
    {
        this.buildDefinitions = buildDefinitions;
    } //-- void setBuildDefinitions(java.util.List) 

    /**
     * Set 
     *             true if this definition is a continuum default
     * build def (cannot be removed)
     *           .
     * 
     * @param continuumDefault
     */
    public void setContinuumDefault(boolean continuumDefault)
    {
        this.continuumDefault = continuumDefault;
    } //-- void setContinuumDefault(boolean) 

    /**
     * Set the id field.
     * 
     * @param id
     */
    public void setId(int id)
    {
        this.id = id;
    } //-- void setId(int) 

    /**
     * Set the name field.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set type of the buid BuildDefinitionTemplate use for
     * default.
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    } //-- void setType(String) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "id = '" );
        buf.append( getId() );
        buf.append( "'" );
        
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
