/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * 
 *         This class is a summary of a single continuum build.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class BuildResult extends BuildResultSummary 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field scmResult.
     */
    private ScmResult scmResult;

    /**
     * Field modifiedDependencies.
     */
    private java.util.List modifiedDependencies;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addModifiedDependency.
     * 
     * @param projectDependency
     */
    public void addModifiedDependency(ProjectDependency projectDependency)
    {
        if ( !(projectDependency instanceof ProjectDependency) )
        {
            throw new ClassCastException( "BuildResult.addModifiedDependencies(projectDependency) parameter must be instanceof " + ProjectDependency.class.getName() );
        }
        getModifiedDependencies().add( projectDependency );
    } //-- void addModifiedDependency(ProjectDependency) 

    /**
     * Method getModifiedDependencies.
     * 
     * @return java.util.List
     */
    public java.util.List getModifiedDependencies()
    {
        if ( this.modifiedDependencies == null )
        {
            this.modifiedDependencies = new java.util.ArrayList();
        }
        
        return this.modifiedDependencies;
    } //-- java.util.List getModifiedDependencies() 

    /**
     * Get the scmResult field.
     * 
     * @return ScmResult
     */
    public ScmResult getScmResult()
    {
        return this.scmResult;
    } //-- ScmResult getScmResult() 

    /**
     * Method removeModifiedDependency.
     * 
     * @param projectDependency
     */
    public void removeModifiedDependency(ProjectDependency projectDependency)
    {
        if ( !(projectDependency instanceof ProjectDependency) )
        {
            throw new ClassCastException( "BuildResult.removeModifiedDependencies(projectDependency) parameter must be instanceof " + ProjectDependency.class.getName() );
        }
        getModifiedDependencies().remove( projectDependency );
    } //-- void removeModifiedDependency(ProjectDependency) 

    /**
     * Set the modifiedDependencies field.
     * 
     * @param modifiedDependencies
     */
    public void setModifiedDependencies(java.util.List modifiedDependencies)
    {
        this.modifiedDependencies = modifiedDependencies;
    } //-- void setModifiedDependencies(java.util.List) 

    /**
     * Set the scmResult field.
     * 
     * @param scmResult
     */
    public void setScmResult(ScmResult scmResult)
    {
        this.scmResult = scmResult;
    } //-- void setScmResult(ScmResult) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
