/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * 
 *         This class is a summary of a single continuum build.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class BuildResultSummary implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id.
     */
    private int id = 0;

    /**
     * Field buildNumber.
     */
    private int buildNumber = 0;

    /**
     * Field state.
     */
    private int state = 0;

    /**
     * Field startTime.
     */
    private long startTime = 0;

    /**
     * Field endTime.
     */
    private long endTime = 0;

    /**
     * Field success.
     */
    private boolean success = false;

    /**
     * Field exitCode.
     */
    private int exitCode = 0;

    /**
     * Field error.
     */
    private String error;

    /**
     * Field trigger.
     */
    private int trigger = 0;

    /**
     * Field project.
     */
    private ProjectSummary project;

    /**
     * Field buildDefinition.
     */
    private BuildDefinition buildDefinition;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof BuildResultSummary) )
        {
            return false;
        }
        
        BuildResultSummary that = (BuildResultSummary) other;
        boolean result = true;
        
        result = result && id == that.id;
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get the buildDefinition field.
     * 
     * @return BuildDefinition
     */
    public BuildDefinition getBuildDefinition()
    {
        return this.buildDefinition;
    } //-- BuildDefinition getBuildDefinition() 

    /**
     * Get the buildNumber field.
     * 
     * @return int
     */
    public int getBuildNumber()
    {
        return this.buildNumber;
    } //-- int getBuildNumber() 

    /**
     * Get the endTime field.
     * 
     * @return long
     */
    public long getEndTime()
    {
        return this.endTime;
    } //-- long getEndTime() 

    /**
     * Get the error field.
     * 
     * @return String
     */
    public String getError()
    {
        return this.error;
    } //-- String getError() 

    /**
     * Get the exitCode field.
     * 
     * @return int
     */
    public int getExitCode()
    {
        return this.exitCode;
    } //-- int getExitCode() 

    /**
     * Get the id field.
     * 
     * @return int
     */
    public int getId()
    {
        return this.id;
    } //-- int getId() 

    /**
     * Get the project field.
     * 
     * @return ProjectSummary
     */
    public ProjectSummary getProject()
    {
        return this.project;
    } //-- ProjectSummary getProject() 

    /**
     * Get the startTime field.
     * 
     * @return long
     */
    public long getStartTime()
    {
        return this.startTime;
    } //-- long getStartTime() 

    /**
     * Get the state field.
     * 
     * @return int
     */
    public int getState()
    {
        return this.state;
    } //-- int getState() 

    /**
     * Get the trigger field.
     * 
     * @return int
     */
    public int getTrigger()
    {
        return this.trigger;
    } //-- int getTrigger() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + (int) id;
        
        return result;
    } //-- int hashCode() 

    /**
     * Get the success field.
     * 
     * @return boolean
     */
    public boolean isSuccess()
    {
        return this.success;
    } //-- boolean isSuccess() 

    /**
     * Set the buildDefinition field.
     * 
     * @param buildDefinition
     */
    public void setBuildDefinition(BuildDefinition buildDefinition)
    {
        this.buildDefinition = buildDefinition;
    } //-- void setBuildDefinition(BuildDefinition) 

    /**
     * Set the buildNumber field.
     * 
     * @param buildNumber
     */
    public void setBuildNumber(int buildNumber)
    {
        this.buildNumber = buildNumber;
    } //-- void setBuildNumber(int) 

    /**
     * Set the endTime field.
     * 
     * @param endTime
     */
    public void setEndTime(long endTime)
    {
        this.endTime = endTime;
    } //-- void setEndTime(long) 

    /**
     * Set the error field.
     * 
     * @param error
     */
    public void setError(String error)
    {
        this.error = error;
    } //-- void setError(String) 

    /**
     * Set the exitCode field.
     * 
     * @param exitCode
     */
    public void setExitCode(int exitCode)
    {
        this.exitCode = exitCode;
    } //-- void setExitCode(int) 

    /**
     * Set the id field.
     * 
     * @param id
     */
    public void setId(int id)
    {
        this.id = id;
    } //-- void setId(int) 

    /**
     * Set the project field.
     * 
     * @param project
     */
    public void setProject(ProjectSummary project)
    {
        this.project = project;
    } //-- void setProject(ProjectSummary) 

    /**
     * Set the startTime field.
     * 
     * @param startTime
     */
    public void setStartTime(long startTime)
    {
        this.startTime = startTime;
    } //-- void setStartTime(long) 

    /**
     * Set the state field.
     * 
     * @param state
     */
    public void setState(int state)
    {
        this.state = state;
    } //-- void setState(int) 

    /**
     * Set the success field.
     * 
     * @param success
     */
    public void setSuccess(boolean success)
    {
        this.success = success;
    } //-- void setSuccess(boolean) 

    /**
     * Set the trigger field.
     * 
     * @param trigger
     */
    public void setTrigger(int trigger)
    {
        this.trigger = trigger;
    } //-- void setTrigger(int) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "id = '" );
        buf.append( getId() );
        buf.append( "'" );
        
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
