/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * Class ContinuumProjectState.
 * 
 * @version $Revision$ $Date$
 */
public class ContinuumProjectState implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field name.
     */
    private String name;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get the name field.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Set the name field.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 


    public final static int NEW = 1;
    public final static int OK = 2;
    public final static int FAILED = 3;
    public final static int ERROR = 4;
    public final static int BUILDING = 6;
    public final static int CHECKING_OUT = 7;
    public final static int UPDATING = 8;
    public final static int WARNING = 9;
    public final static int CHECKEDOUT = 10;

    // TODO: maybe move these to another class
    public static final int TRIGGER_FORCED = 1;

    // TODO: remove
    public static final int TRIGGER_SCHEDULED = 0;

    public static final int TRIGGER_UNKNOWN = TRIGGER_SCHEDULED;

    public String getI18nKey()
    {
        return "org.apache.maven.continuum.project.state." + name;
    }

    public boolean equals( Object object )
    {
        if ( !( object instanceof ContinuumProjectState ) )
        {
            return false;
        }

        ContinuumProjectState other = (ContinuumProjectState) object;

        return name.equals( other.name );
    }

    public int hashCode()
    {
        return name.hashCode();
    }

    public String toString()
    {
        return name;
    }
           
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
