/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * Class Project.
 * 
 * @version $Revision$ $Date$
 */
public class Project extends ProjectSummary 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field parent.
     */
    private ProjectDependency parent;

    /**
     * Field developers.
     */
    private java.util.List developers;

    /**
     * Field dependencies.
     */
    private java.util.List dependencies;

    /**
     * Field notifiers.
     */
    private java.util.List notifiers;

    /**
     * Field buildDefinitions.
     */
    private java.util.List buildDefinitions;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addBuildDefinition.
     * 
     * @param buildDefinition
     */
    public void addBuildDefinition(BuildDefinition buildDefinition)
    {
        if ( !(buildDefinition instanceof BuildDefinition) )
        {
            throw new ClassCastException( "Project.addBuildDefinitions(buildDefinition) parameter must be instanceof " + BuildDefinition.class.getName() );
        }
        getBuildDefinitions().add( buildDefinition );
    } //-- void addBuildDefinition(BuildDefinition) 

    /**
     * Method addDependency.
     * 
     * @param projectDependency
     */
    public void addDependency(ProjectDependency projectDependency)
    {
        if ( !(projectDependency instanceof ProjectDependency) )
        {
            throw new ClassCastException( "Project.addDependencies(projectDependency) parameter must be instanceof " + ProjectDependency.class.getName() );
        }
        getDependencies().add( projectDependency );
    } //-- void addDependency(ProjectDependency) 

    /**
     * Method addDeveloper.
     * 
     * @param projectDeveloper
     */
    public void addDeveloper(ProjectDeveloper projectDeveloper)
    {
        if ( !(projectDeveloper instanceof ProjectDeveloper) )
        {
            throw new ClassCastException( "Project.addDevelopers(projectDeveloper) parameter must be instanceof " + ProjectDeveloper.class.getName() );
        }
        getDevelopers().add( projectDeveloper );
    } //-- void addDeveloper(ProjectDeveloper) 

    /**
     * Method addNotifier.
     * 
     * @param projectNotifier
     */
    public void addNotifier(ProjectNotifier projectNotifier)
    {
        if ( !(projectNotifier instanceof ProjectNotifier) )
        {
            throw new ClassCastException( "Project.addNotifiers(projectNotifier) parameter must be instanceof " + ProjectNotifier.class.getName() );
        }
        getNotifiers().add( projectNotifier );
    } //-- void addNotifier(ProjectNotifier) 

    /**
     * Method getBuildDefinitions.
     * 
     * @return java.util.List
     */
    public java.util.List getBuildDefinitions()
    {
        if ( this.buildDefinitions == null )
        {
            this.buildDefinitions = new java.util.ArrayList();
        }
        
        return this.buildDefinitions;
    } //-- java.util.List getBuildDefinitions() 

    /**
     * Method getDependencies.
     * 
     * @return java.util.List
     */
    public java.util.List getDependencies()
    {
        if ( this.dependencies == null )
        {
            this.dependencies = new java.util.ArrayList();
        }
        
        return this.dependencies;
    } //-- java.util.List getDependencies() 

    /**
     * Method getDevelopers.
     * 
     * @return java.util.List
     */
    public java.util.List getDevelopers()
    {
        if ( this.developers == null )
        {
            this.developers = new java.util.ArrayList();
        }
        
        return this.developers;
    } //-- java.util.List getDevelopers() 

    /**
     * Method getNotifiers.
     * 
     * @return java.util.List
     */
    public java.util.List getNotifiers()
    {
        if ( this.notifiers == null )
        {
            this.notifiers = new java.util.ArrayList();
        }
        
        return this.notifiers;
    } //-- java.util.List getNotifiers() 

    /**
     * Get the parent field.
     * 
     * @return ProjectDependency
     */
    public ProjectDependency getParent()
    {
        return this.parent;
    } //-- ProjectDependency getParent() 

    /**
     * Method removeBuildDefinition.
     * 
     * @param buildDefinition
     */
    public void removeBuildDefinition(BuildDefinition buildDefinition)
    {
        if ( !(buildDefinition instanceof BuildDefinition) )
        {
            throw new ClassCastException( "Project.removeBuildDefinitions(buildDefinition) parameter must be instanceof " + BuildDefinition.class.getName() );
        }
        getBuildDefinitions().remove( buildDefinition );
    } //-- void removeBuildDefinition(BuildDefinition) 

    /**
     * Method removeDependency.
     * 
     * @param projectDependency
     */
    public void removeDependency(ProjectDependency projectDependency)
    {
        if ( !(projectDependency instanceof ProjectDependency) )
        {
            throw new ClassCastException( "Project.removeDependencies(projectDependency) parameter must be instanceof " + ProjectDependency.class.getName() );
        }
        getDependencies().remove( projectDependency );
    } //-- void removeDependency(ProjectDependency) 

    /**
     * Method removeDeveloper.
     * 
     * @param projectDeveloper
     */
    public void removeDeveloper(ProjectDeveloper projectDeveloper)
    {
        if ( !(projectDeveloper instanceof ProjectDeveloper) )
        {
            throw new ClassCastException( "Project.removeDevelopers(projectDeveloper) parameter must be instanceof " + ProjectDeveloper.class.getName() );
        }
        getDevelopers().remove( projectDeveloper );
    } //-- void removeDeveloper(ProjectDeveloper) 

    /**
     * Method removeNotifier.
     * 
     * @param projectNotifier
     */
    public void removeNotifier(ProjectNotifier projectNotifier)
    {
        if ( !(projectNotifier instanceof ProjectNotifier) )
        {
            throw new ClassCastException( "Project.removeNotifiers(projectNotifier) parameter must be instanceof " + ProjectNotifier.class.getName() );
        }
        getNotifiers().remove( projectNotifier );
    } //-- void removeNotifier(ProjectNotifier) 

    /**
     * Set the buildDefinitions field.
     * 
     * @param buildDefinitions
     */
    public void setBuildDefinitions(java.util.List buildDefinitions)
    {
        this.buildDefinitions = buildDefinitions;
    } //-- void setBuildDefinitions(java.util.List) 

    /**
     * Set the dependencies field.
     * 
     * @param dependencies
     */
    public void setDependencies(java.util.List dependencies)
    {
        this.dependencies = dependencies;
    } //-- void setDependencies(java.util.List) 

    /**
     * Set the developers field.
     * 
     * @param developers
     */
    public void setDevelopers(java.util.List developers)
    {
        this.developers = developers;
    } //-- void setDevelopers(java.util.List) 

    /**
     * Set the notifiers field.
     * 
     * @param notifiers
     */
    public void setNotifiers(java.util.List notifiers)
    {
        this.notifiers = notifiers;
    } //-- void setNotifiers(java.util.List) 

    /**
     * Set the parent field.
     * 
     * @param parent
     */
    public void setParent(ProjectDependency parent)
    {
        this.parent = parent;
    } //-- void setParent(ProjectDependency) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
