/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * Class ProjectGroup.
 * 
 * @version $Revision$ $Date$
 */
public class ProjectGroup extends ProjectGroupSummary 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field projects.
     */
    private java.util.List projects;

    /**
     * Field notifiers.
     */
    private java.util.List notifiers;

    /**
     * Field buildDefinitions.
     */
    private java.util.List buildDefinitions;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addBuildDefinition.
     * 
     * @param buildDefinition
     */
    public void addBuildDefinition(BuildDefinition buildDefinition)
    {
        if ( !(buildDefinition instanceof BuildDefinition) )
        {
            throw new ClassCastException( "ProjectGroup.addBuildDefinitions(buildDefinition) parameter must be instanceof " + BuildDefinition.class.getName() );
        }
        getBuildDefinitions().add( buildDefinition );
    } //-- void addBuildDefinition(BuildDefinition) 

    /**
     * Method addNotifier.
     * 
     * @param projectNotifier
     */
    public void addNotifier(ProjectNotifier projectNotifier)
    {
        if ( !(projectNotifier instanceof ProjectNotifier) )
        {
            throw new ClassCastException( "ProjectGroup.addNotifiers(projectNotifier) parameter must be instanceof " + ProjectNotifier.class.getName() );
        }
        getNotifiers().add( projectNotifier );
    } //-- void addNotifier(ProjectNotifier) 

    /**
     * Method addProject.
     * 
     * @param projectSummary
     */
    public void addProject(ProjectSummary projectSummary)
    {
        if ( !(projectSummary instanceof ProjectSummary) )
        {
            throw new ClassCastException( "ProjectGroup.addProjects(projectSummary) parameter must be instanceof " + ProjectSummary.class.getName() );
        }
        getProjects().add( projectSummary );
    } //-- void addProject(ProjectSummary) 

    /**
     * Method getBuildDefinitions.
     * 
     * @return java.util.List
     */
    public java.util.List getBuildDefinitions()
    {
        if ( this.buildDefinitions == null )
        {
            this.buildDefinitions = new java.util.ArrayList();
        }
        
        return this.buildDefinitions;
    } //-- java.util.List getBuildDefinitions() 

    /**
     * Method getNotifiers.
     * 
     * @return java.util.List
     */
    public java.util.List getNotifiers()
    {
        if ( this.notifiers == null )
        {
            this.notifiers = new java.util.ArrayList();
        }
        
        return this.notifiers;
    } //-- java.util.List getNotifiers() 

    /**
     * Method getProjects.
     * 
     * @return java.util.List
     */
    public java.util.List getProjects()
    {
        if ( this.projects == null )
        {
            this.projects = new java.util.ArrayList();
        }
        
        return this.projects;
    } //-- java.util.List getProjects() 

    /**
     * Method removeBuildDefinition.
     * 
     * @param buildDefinition
     */
    public void removeBuildDefinition(BuildDefinition buildDefinition)
    {
        if ( !(buildDefinition instanceof BuildDefinition) )
        {
            throw new ClassCastException( "ProjectGroup.removeBuildDefinitions(buildDefinition) parameter must be instanceof " + BuildDefinition.class.getName() );
        }
        getBuildDefinitions().remove( buildDefinition );
    } //-- void removeBuildDefinition(BuildDefinition) 

    /**
     * Method removeNotifier.
     * 
     * @param projectNotifier
     */
    public void removeNotifier(ProjectNotifier projectNotifier)
    {
        if ( !(projectNotifier instanceof ProjectNotifier) )
        {
            throw new ClassCastException( "ProjectGroup.removeNotifiers(projectNotifier) parameter must be instanceof " + ProjectNotifier.class.getName() );
        }
        getNotifiers().remove( projectNotifier );
    } //-- void removeNotifier(ProjectNotifier) 

    /**
     * Method removeProject.
     * 
     * @param projectSummary
     */
    public void removeProject(ProjectSummary projectSummary)
    {
        if ( !(projectSummary instanceof ProjectSummary) )
        {
            throw new ClassCastException( "ProjectGroup.removeProjects(projectSummary) parameter must be instanceof " + ProjectSummary.class.getName() );
        }
        getProjects().remove( projectSummary );
    } //-- void removeProject(ProjectSummary) 

    /**
     * Set the buildDefinitions field.
     * 
     * @param buildDefinitions
     */
    public void setBuildDefinitions(java.util.List buildDefinitions)
    {
        this.buildDefinitions = buildDefinitions;
    } //-- void setBuildDefinitions(java.util.List) 

    /**
     * Set the notifiers field.
     * 
     * @param notifiers
     */
    public void setNotifiers(java.util.List notifiers)
    {
        this.notifiers = notifiers;
    } //-- void setNotifiers(java.util.List) 

    /**
     * Set the projects field.
     * 
     * @param projects
     */
    public void setProjects(java.util.List projects)
    {
        this.projects = projects;
    } //-- void setProjects(java.util.List) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
