/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * Class ProjectGroupSummary.
 * 
 * @version $Revision$ $Date$
 */
public class ProjectGroupSummary implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id.
     */
    private int id = 0;

    /**
     * Field groupId.
     */
    private String groupId;

    /**
     * Field name.
     */
    private String name;

    /**
     * Field description.
     */
    private String description;

    /**
     * Field localRepository.
     */
    private LocalRepository localRepository;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof ProjectGroupSummary) )
        {
            return false;
        }
        
        ProjectGroupSummary that = (ProjectGroupSummary) other;
        boolean result = true;
        
        result = result && id == that.id;
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get the description field.
     * 
     * @return String
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Get the groupId field.
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get the id field.
     * 
     * @return int
     */
    public int getId()
    {
        return this.id;
    } //-- int getId() 

    /**
     * Get the localRepository field.
     * 
     * @return LocalRepository
     */
    public LocalRepository getLocalRepository()
    {
        return this.localRepository;
    } //-- LocalRepository getLocalRepository() 

    /**
     * Get the name field.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + (int) id;
        
        return result;
    } //-- int hashCode() 

    /**
     * Set the description field.
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Set the groupId field.
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set the id field.
     * 
     * @param id
     */
    public void setId(int id)
    {
        this.id = id;
    } //-- void setId(int) 

    /**
     * Set the localRepository field.
     * 
     * @param localRepository
     */
    public void setLocalRepository(LocalRepository localRepository)
    {
        this.localRepository = localRepository;
    } //-- void setLocalRepository(LocalRepository) 

    /**
     * Set the name field.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "id = '" );
        buf.append( getId() );
        buf.append( "'" );
        
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
