/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * 
 *         Configures one method for notifying users/developers
 * when a build breaks.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class ProjectNotifier implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id.
     */
    private int id = 0;

    /**
     * The mechanism used to deliver notifications.
     */
    private String type = "mail";

    /**
     * The origin of the notifier (pom or user).
     */
    private int from = 0;

    /**
     * Field enabled.
     */
    private boolean enabled = true;

    /**
     * Field recipientType.
     */
    private int recipientType = 0;

    /**
     * Field sendOnSuccess.
     */
    private boolean sendOnSuccess = true;

    /**
     * Field sendOnFailure.
     */
    private boolean sendOnFailure = true;

    /**
     * Field sendOnError.
     */
    private boolean sendOnError = true;

    /**
     * Field sendOnWarning.
     */
    private boolean sendOnWarning = true;

    /**
     * Field configuration.
     */
    private java.util.Map configuration;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addConfiguration.
     * 
     * @param key
     * @param value
     */
    public void addConfiguration(Object key, String value)
    {
        getConfiguration().put( key, value );
    } //-- void addConfiguration(Object, String) 

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof ProjectNotifier) )
        {
            return false;
        }
        
        ProjectNotifier that = (ProjectNotifier) other;
        boolean result = true;
        
        result = result && id == that.id;
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Method getConfiguration.
     * 
     * @return java.util.Map
     */
    public java.util.Map getConfiguration()
    {
        if ( this.configuration == null )
        {
            this.configuration = new java.util.HashMap();
        }
        
        return this.configuration;
    } //-- java.util.Map getConfiguration() 

    /**
     * Get the origin of the notifier (pom or user).
     * 
     * @return int
     */
    public int getFrom()
    {
        return this.from;
    } //-- int getFrom() 

    /**
     * Get the id field.
     * 
     * @return int
     */
    public int getId()
    {
        return this.id;
    } //-- int getId() 

    /**
     * Get the recipientType field.
     * 
     * @return int
     */
    public int getRecipientType()
    {
        return this.recipientType;
    } //-- int getRecipientType() 

    /**
     * Get the mechanism used to deliver notifications.
     * 
     * @return String
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + (int) id;
        
        return result;
    } //-- int hashCode() 

    /**
     * Get the enabled field.
     * 
     * @return boolean
     */
    public boolean isEnabled()
    {
        return this.enabled;
    } //-- boolean isEnabled() 

    /**
     * Get the sendOnError field.
     * 
     * @return boolean
     */
    public boolean isSendOnError()
    {
        return this.sendOnError;
    } //-- boolean isSendOnError() 

    /**
     * Get the sendOnFailure field.
     * 
     * @return boolean
     */
    public boolean isSendOnFailure()
    {
        return this.sendOnFailure;
    } //-- boolean isSendOnFailure() 

    /**
     * Get the sendOnSuccess field.
     * 
     * @return boolean
     */
    public boolean isSendOnSuccess()
    {
        return this.sendOnSuccess;
    } //-- boolean isSendOnSuccess() 

    /**
     * Get the sendOnWarning field.
     * 
     * @return boolean
     */
    public boolean isSendOnWarning()
    {
        return this.sendOnWarning;
    } //-- boolean isSendOnWarning() 

    /**
     * Set extended configuration specific to this notifier goes
     * here.
     * 
     * @param configuration
     */
    public void setConfiguration(java.util.Map configuration)
    {
        this.configuration = configuration;
    } //-- void setConfiguration(java.util.Map) 

    /**
     * Set the enabled field.
     * 
     * @param enabled
     */
    public void setEnabled(boolean enabled)
    {
        this.enabled = enabled;
    } //-- void setEnabled(boolean) 

    /**
     * Set the origin of the notifier (pom or user).
     * 
     * @param from
     */
    public void setFrom(int from)
    {
        this.from = from;
    } //-- void setFrom(int) 

    /**
     * Set the id field.
     * 
     * @param id
     */
    public void setId(int id)
    {
        this.id = id;
    } //-- void setId(int) 

    /**
     * Set the recipientType field.
     * 
     * @param recipientType
     */
    public void setRecipientType(int recipientType)
    {
        this.recipientType = recipientType;
    } //-- void setRecipientType(int) 

    /**
     * Set the sendOnError field.
     * 
     * @param sendOnError
     */
    public void setSendOnError(boolean sendOnError)
    {
        this.sendOnError = sendOnError;
    } //-- void setSendOnError(boolean) 

    /**
     * Set the sendOnFailure field.
     * 
     * @param sendOnFailure
     */
    public void setSendOnFailure(boolean sendOnFailure)
    {
        this.sendOnFailure = sendOnFailure;
    } //-- void setSendOnFailure(boolean) 

    /**
     * Set the sendOnSuccess field.
     * 
     * @param sendOnSuccess
     */
    public void setSendOnSuccess(boolean sendOnSuccess)
    {
        this.sendOnSuccess = sendOnSuccess;
    } //-- void setSendOnSuccess(boolean) 

    /**
     * Set the sendOnWarning field.
     * 
     * @param sendOnWarning
     */
    public void setSendOnWarning(boolean sendOnWarning)
    {
        this.sendOnWarning = sendOnWarning;
    } //-- void setSendOnWarning(boolean) 

    /**
     * Set the mechanism used to deliver notifications.
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    } //-- void setType(String) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "id = '" );
        buf.append( getId() );
        buf.append( "'" );
        
        return buf.toString();
    } //-- java.lang.String toString() 



              public static final int FROM_PROJECT = 1;

              public static final int FROM_USER = 2;

              public boolean isFromProject()
              {
                  return from == FROM_PROJECT;
              }

              public boolean isFromUser()
              {
                  return from == FROM_USER;
              }
          
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
