/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * Class ProjectSummary.
 * 
 * @version $Revision$ $Date$
 */
public class ProjectSummary implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id.
     */
    private int id = 0;

    /**
     * Field groupId.
     */
    private String groupId;

    /**
     * Field artifactId.
     */
    private String artifactId;

    /**
     * Field executorId.
     */
    private String executorId;

    /**
     * Field name.
     */
    private String name;

    /**
     * Field description.
     */
    private String description;

    /**
     * Field url.
     */
    private String url;

    /**
     * Field scmUrl.
     */
    private String scmUrl;

    /**
     * Field scmTag.
     */
    private String scmTag;

    /**
     * Field scmUsername.
     */
    private String scmUsername;

    /**
     * Field scmPassword.
     */
    private String scmPassword;

    /**
     * Field scmUseCache.
     */
    private boolean scmUseCache = false;

    /**
     * Field version.
     */
    private String version;

    /**
     * Field state.
     */
    private int state = 1;

    /**
     * Field oldState.
     */
    private int oldState = 0;

    /**
     * Field latestBuildId.
     */
    private int latestBuildId = 0;

    /**
     * Field buildNumber.
     */
    private int buildNumber = 0;

    /**
     * Field workingDirectory.
     */
    private String workingDirectory;

    /**
     * Field relativePath.
     */
    private String relativePath;

    /**
     * Field projectGroup.
     */
    private ProjectGroupSummary projectGroup;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof ProjectSummary) )
        {
            return false;
        }
        
        ProjectSummary that = (ProjectSummary) other;
        boolean result = true;
        
        result = result && id == that.id;
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get the artifactId field.
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get the buildNumber field.
     * 
     * @return int
     */
    public int getBuildNumber()
    {
        return this.buildNumber;
    } //-- int getBuildNumber() 

    /**
     * Get the description field.
     * 
     * @return String
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Get the executorId field.
     * 
     * @return String
     */
    public String getExecutorId()
    {
        return this.executorId;
    } //-- String getExecutorId() 

    /**
     * Get the groupId field.
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get the id field.
     * 
     * @return int
     */
    public int getId()
    {
        return this.id;
    } //-- int getId() 

    /**
     * Get the latestBuildId field.
     * 
     * @return int
     */
    public int getLatestBuildId()
    {
        return this.latestBuildId;
    } //-- int getLatestBuildId() 

    /**
     * Get the name field.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get the oldState field.
     * 
     * @return int
     */
    public int getOldState()
    {
        return this.oldState;
    } //-- int getOldState() 

    /**
     * Get the projectGroup field.
     * 
     * @return ProjectGroupSummary
     */
    public ProjectGroupSummary getProjectGroup()
    {
        return this.projectGroup;
    } //-- ProjectGroupSummary getProjectGroup() 

    /**
     * Get the relativePath field.
     * 
     * @return String
     */
    public String getRelativePath()
    {
        return this.relativePath;
    } //-- String getRelativePath() 

    /**
     * Get the scmPassword field.
     * 
     * @return String
     */
    public String getScmPassword()
    {
        return this.scmPassword;
    } //-- String getScmPassword() 

    /**
     * Get the scmTag field.
     * 
     * @return String
     */
    public String getScmTag()
    {
        return this.scmTag;
    } //-- String getScmTag() 

    /**
     * Get the scmUrl field.
     * 
     * @return String
     */
    public String getScmUrl()
    {
        return this.scmUrl;
    } //-- String getScmUrl() 

    /**
     * Get the scmUsername field.
     * 
     * @return String
     */
    public String getScmUsername()
    {
        return this.scmUsername;
    } //-- String getScmUsername() 

    /**
     * Get the state field.
     * 
     * @return int
     */
    public int getState()
    {
        return this.state;
    } //-- int getState() 

    /**
     * Get the url field.
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Get the version field.
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Get the workingDirectory field.
     * 
     * @return String
     */
    public String getWorkingDirectory()
    {
        return this.workingDirectory;
    } //-- String getWorkingDirectory() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + (int) id;
        
        return result;
    } //-- int hashCode() 

    /**
     * Get the scmUseCache field.
     * 
     * @return boolean
     */
    public boolean isScmUseCache()
    {
        return this.scmUseCache;
    } //-- boolean isScmUseCache() 

    /**
     * Set the artifactId field.
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set the buildNumber field.
     * 
     * @param buildNumber
     */
    public void setBuildNumber(int buildNumber)
    {
        this.buildNumber = buildNumber;
    } //-- void setBuildNumber(int) 

    /**
     * Set the description field.
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Set the executorId field.
     * 
     * @param executorId
     */
    public void setExecutorId(String executorId)
    {
        this.executorId = executorId;
    } //-- void setExecutorId(String) 

    /**
     * Set the groupId field.
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set the id field.
     * 
     * @param id
     */
    public void setId(int id)
    {
        this.id = id;
    } //-- void setId(int) 

    /**
     * Set the latestBuildId field.
     * 
     * @param latestBuildId
     */
    public void setLatestBuildId(int latestBuildId)
    {
        this.latestBuildId = latestBuildId;
    } //-- void setLatestBuildId(int) 

    /**
     * Set the name field.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set the oldState field.
     * 
     * @param oldState
     */
    public void setOldState(int oldState)
    {
        this.oldState = oldState;
    } //-- void setOldState(int) 

    /**
     * Set the projectGroup field.
     * 
     * @param projectGroup
     */
    public void setProjectGroup(ProjectGroupSummary projectGroup)
    {
        this.projectGroup = projectGroup;
    } //-- void setProjectGroup(ProjectGroupSummary) 

    /**
     * Set the relativePath field.
     * 
     * @param relativePath
     */
    public void setRelativePath(String relativePath)
    {
        this.relativePath = relativePath;
    } //-- void setRelativePath(String) 

    /**
     * Set the scmPassword field.
     * 
     * @param scmPassword
     */
    public void setScmPassword(String scmPassword)
    {
        this.scmPassword = scmPassword;
    } //-- void setScmPassword(String) 

    /**
     * Set the scmTag field.
     * 
     * @param scmTag
     */
    public void setScmTag(String scmTag)
    {
        this.scmTag = scmTag;
    } //-- void setScmTag(String) 

    /**
     * Set the scmUrl field.
     * 
     * @param scmUrl
     */
    public void setScmUrl(String scmUrl)
    {
        this.scmUrl = scmUrl;
    } //-- void setScmUrl(String) 

    /**
     * Set the scmUseCache field.
     * 
     * @param scmUseCache
     */
    public void setScmUseCache(boolean scmUseCache)
    {
        this.scmUseCache = scmUseCache;
    } //-- void setScmUseCache(boolean) 

    /**
     * Set the scmUsername field.
     * 
     * @param scmUsername
     */
    public void setScmUsername(String scmUsername)
    {
        this.scmUsername = scmUsername;
    } //-- void setScmUsername(String) 

    /**
     * Set the state field.
     * 
     * @param state
     */
    public void setState(int state)
    {
        this.state = state;
    } //-- void setState(int) 

    /**
     * Set the url field.
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 

    /**
     * Set the version field.
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 

    /**
     * Set the workingDirectory field.
     * 
     * @param workingDirectory
     */
    public void setWorkingDirectory(String workingDirectory)
    {
        this.workingDirectory = workingDirectory;
    } //-- void setWorkingDirectory(String) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "id = '" );
        buf.append( getId() );
        buf.append( "'" );
        
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
