/*
 * $Id$
 */

package org.apache.maven.continuum.xmlrpc.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.continuum.xmlrpc.release.ContinuumReleaseResult;
import org.apache.continuum.xmlrpc.repository.AbstractPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.DirectoryPurgeConfiguration;
import org.apache.continuum.xmlrpc.repository.LocalRepository;
import org.apache.continuum.xmlrpc.repository.RepositoryPurgeConfiguration;
import org.apache.maven.continuum.xmlrpc.scm.ChangeFile;
import org.apache.maven.continuum.xmlrpc.scm.ChangeSet;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.system.Profile;
import org.apache.maven.continuum.xmlrpc.system.SystemConfiguration;

/**
 * 
 *         Schedule for a project.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Schedule implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id.
     */
    private int id = 0;

    /**
     * Field active.
     */
    private boolean active = false;

    /**
     * Field name.
     */
    private String name;

    /**
     * Field description.
     */
    private String description;

    /**
     * 
     *             Delay in seconds.
     *           
     */
    private int delay = 0;

    /**
     * 
     *             Maximum execution time of a job in seconds
     * before it's
     *             terminated.
     *           
     */
    private int maxJobExecutionTime = 3600;

    /**
     * Field cronExpression.
     */
    private String cronExpression;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof Schedule) )
        {
            return false;
        }
        
        Schedule that = (Schedule) other;
        boolean result = true;
        
        result = result && id == that.id;
        
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get the cronExpression field.
     * 
     * @return String
     */
    public String getCronExpression()
    {
        return this.cronExpression;
    } //-- String getCronExpression() 

    /**
     * Get 
     *             Delay in seconds.
     *           
     * 
     * @return int
     */
    public int getDelay()
    {
        return this.delay;
    } //-- int getDelay() 

    /**
     * Get the description field.
     * 
     * @return String
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Get the id field.
     * 
     * @return int
     */
    public int getId()
    {
        return this.id;
    } //-- int getId() 

    /**
     * Get 
     *             Maximum execution time of a job in seconds
     * before it's
     *             terminated.
     *           
     * 
     * @return int
     */
    public int getMaxJobExecutionTime()
    {
        return this.maxJobExecutionTime;
    } //-- int getMaxJobExecutionTime() 

    /**
     * Get the name field.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;
        
        result = 37 * result + (int) id;
        
        return result;
    } //-- int hashCode() 

    /**
     * Get the active field.
     * 
     * @return boolean
     */
    public boolean isActive()
    {
        return this.active;
    } //-- boolean isActive() 

    /**
     * Set the active field.
     * 
     * @param active
     */
    public void setActive(boolean active)
    {
        this.active = active;
    } //-- void setActive(boolean) 

    /**
     * Set the cronExpression field.
     * 
     * @param cronExpression
     */
    public void setCronExpression(String cronExpression)
    {
        this.cronExpression = cronExpression;
    } //-- void setCronExpression(String) 

    /**
     * Set 
     *             Delay in seconds.
     *           
     * 
     * @param delay
     */
    public void setDelay(int delay)
    {
        this.delay = delay;
    } //-- void setDelay(int) 

    /**
     * Set the description field.
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Set the id field.
     * 
     * @param id
     */
    public void setId(int id)
    {
        this.id = id;
    } //-- void setId(int) 

    /**
     * Set 
     *             Maximum execution time of a job in seconds
     * before it's
     *             terminated.
     *           
     * 
     * @param maxJobExecutionTime
     */
    public void setMaxJobExecutionTime(int maxJobExecutionTime)
    {
        this.maxJobExecutionTime = maxJobExecutionTime;
    } //-- void setMaxJobExecutionTime(int) 

    /**
     * Set the name field.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Method toString.
     * 
     * @return java.lang.String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        
        buf.append( "id = '" );
        buf.append( getId() );
        buf.append( "'" );
        
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
